<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pedidos_general_01', function (Blueprint $table) {
            $table->id('idweb');
            $table->bigInteger('iddesk');
            $table->bigInteger('idsucursal');
            $table->tinyInteger('origen_registro');
            $table->timestamp('created_at')->nullable()->useCurrent();
            $table->timestamp('updated_at')->useCurrentOnUpdate()->nullable();
            $table->bigInteger('foliopedido');
            $table->integer('idstatus');
            $table->date('fechapedidogeneral')->nullable();
            $table->string('horapedidogeneral', 20);
            $table->bigInteger('idcliente');
            $table->decimal('importe', 18, 6);
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->bigInteger('idusuario');
            $table->string('comentarios', 100)->nullable();
            $table->string('repartidor', 80);
            $table->smallInteger('pedidoyaentregado');
            $table->string('origen', 30);
            $table->bigInteger('idorigen')->nullable();
            $table->string('condiciones', 60)->nullable();
            $table->string('rfc_a_facturar', 20)->nullable();
            $table->bigInteger('idcliente_a_facturar')->nullable();
            $table->smallInteger('facturado')->nullable();
            $table->bigInteger('idcfdigeneral')->nullable();
            $table->string('cfdi_uuid', 36)->nullable();
            $table->smallInteger('pagado')->nullable();
            $table->decimal('total_abonado', 18, 6)->nullable();
            $table->decimal('total_saldo', 18, 6)->nullable();
            $table->date('fecha_vencimiento')->nullable();
            $table->date('fecha_pago')->nullable();
            $table->string('referencia1', 80)->nullable();
            $table->string('referencia2', 80)->nullable();
            $table->string('moneda', 20)->nullable();
            $table->string('importeletra', 120)->nullable();
            $table->integer('anio')->nullable();
            $table->integer('mes')->nullable();
            $table->integer('dia')->nullable();
            $table->string('cfdi_serie', 25)->nullable();
            $table->bigInteger('cfdi_folio')->nullable();
            $table->string('cfdi_receptornombre', 180)->nullable();
            $table->string('usuario', 50)->nullable();
            $table->string('from_host', 50)->nullable();
            $table->string('origen_movimiento', 50)->nullable();
            $table->decimal('costototal', 18, 6)->nullable()->default(0);
            $table->decimal('utilidadtotal', 18, 6)->nullable()->default(0);
            $table->bigInteger('idturno')->nullable();
            $table->decimal('traslado_ieps_importe', 18, 6)->nullable();
            $table->decimal('traslado_iva_importe', 18, 6)->nullable();
            $table->decimal('retencion_iva_importe', 18, 6)->nullable();
            $table->decimal('retencion_isr_importe', 18, 6)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pedidos_general_01');
    }
};
