<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ventasdetalle', function (Blueprint $table) {
            $table->id('idventadetalle');
            $table->bigInteger('idventadetalle_desk')->nullable();
            $table->bigInteger('idventageneral');
            $table->integer('idsucursal');
            $table->bigInteger('idproducto')->nullable();
            $table->bigInteger('idfamilia')->nullable();
            $table->bigInteger('idmarca')->nullable();
            $table->string('clave', 30)->nullable();
            $table->string('descripcion', 120);
            $table->decimal('cantidad', 18, 6);
            $table->decimal('precio', 18, 6);
            $table->decimal('importe', 18, 6);
            $table->timestamp('fechahora')->nullable();
            $table->decimal('descuentox100', 18, 6);
            $table->decimal('descuento', 18, 6);
            $table->decimal('subtotal', 18, 6);
            $table->decimal('iva', 18, 6);
            $table->decimal('total', 18, 6);
            $table->bigInteger('idalmacen');
            $table->decimal('costopromedio', 18, 6)->nullable();
            $table->decimal('costo_venta', 18, 6);
            $table->decimal('utilidad', 18, 6);
            $table->boolean('origen_registro')->nullable();
            $table->string('clave_marca', 20)->nullable();
            $table->string('clave_familia', 20)->nullable();
            $table->bigInteger('idusuario')->nullable();
            $table->bigInteger('idusuario_desk')->nullable();
            $table->bigInteger('idturno')->nullable();
            $table->bigInteger('idturno_desk')->nullable();
            $table->boolean('vtagral_idstatus')->nullable();
            $table->integer('idtipodocumento')->nullable();
            $table->bigInteger('folio')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ventasdetalle');
    }
};
