<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cat_rutas', function (Blueprint $table) {
            $table->integer('idruta')->primary()->autoIncrement();
            $table->string('nombreruta', 20);
            $table->tinyInteger('origen_registro');
            
            // Índices adicionales
            $table->index('idruta');
            $table->unique('idruta');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cat_rutas');
    }
};
