<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('cat_almacenes_AI', function ($trigger) {
            $trigger->on('cat_almacenes');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                '
                  DECLARE m_idproduct INT;
                  DECLARE vManejaInventario INT;
                  DECLARE fin INT;
                  DECLARE cur_prod CURSOR FOR SELECT idproduct,manejainventario FROM cat_productos;
                  DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                  OPEN cur_prod;
                        ins_loop: LOOP
                            FETCH cur_prod INTO m_idproduct,vManejaInventario;
                            IF fin=1 THEN
                                LEAVE ins_loop;
                            END IF;
                            IF vManejaInventario = 1 THEN
                                INSERT INTO mov_inv_existencias (idsucursal, idinventario, idproducto, idalmacen,
                                                                 existencia, contados, idsucursalorigen, origen_registro, descargado)
                                VALUES (NEW.idsucursal, 0, m_idproduct, NEW.idwarehouse,0,0,NEW.idwarehouse,\'WEB\',1);
                            END IF;

                        END LOOP;
                  CLOSE cur_prod;
                '
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('cat_almacenes_AI');
    }
};
