<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('producto_insert', function ($trigger) {
            $trigger->on('cat_productos');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'DECLARE m_idsucursal INT;
                DECLARE m_idwarehouse INT;
                DECLARE fin int;
                DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales;
                DECLARE cur_alm CURSOR FOR SELECT idwarehouse, idsucursal FROM cat_almacenes;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                IF NEW.manejainventario=1 THEN
                    OPEN cur_alm;
                    ins_loop_alm: LOOP
                        FETCH cur_alm INTO m_idwarehouse, m_idsucursal;
                        IF fin=1 THEN
                            LEAVE ins_loop_alm;
                        END IF;
                        INSERT INTO mov_inv_existencias(idinventario, idproducto, idalmacen, existencia, idsucursal, contados, idsucursalorigen, origen_registro, descargado)
                        VALUES (0, NEW.idproduct, m_idwarehouse, 0, m_idsucursal, 0, m_idsucursal, \'WEB\'  , 0);
                    END LOOP;
                    CLOSE cur_alm;
                END IF;

                SET fin=0;

                IF NEW.origen_registro = \'WEB\' THEN
                    OPEN cur;
                    ins_loop_suc: LOOP
                        FETCH cur INTO m_idsucursal;
                        IF fin=1 THEN
                            LEAVE ins_loop_suc;
                        END IF;
                        INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                        VALUES (m_idsucursal, NEW.idproduct, \'I\', \'PRODUCTOS\');
                    END LOOP;
                    CLOSE cur;
                END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('producto_insert');
    }
};
