<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('producto_delete', function ($trigger) {
            $trigger->on('cat_productos');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::DELETE);
            $trigger->statement(
                'DECLARE m_idsucursal INT;
                DECLARE fin int;
                DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                DELETE FROM mov_changes WHERE tabla = \'PRODUCTOS\' AND identable = OLD.idproduct;
                DELETE FROM mov_inv_existencias WHERE idproducto = OLD.idproduct;
                DELETE c FROM mov_changes c INNER JOIN mov_inv_detalle vd ON vd.idmovinventariodet = c.identable WHERE vd.idproducto = OLD.idproduct;

                OPEN cur;
                ins_loop: LOOP
                    FETCH cur INTO m_idsucursal;
                    IF fin=1 THEN
                        LEAVE ins_loop;
                    END IF;
                    INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                    VALUES (m_idsucursal, OLD.idproduct, \'D\', \'PRODUCTOS\');
                END LOOP;
                CLOSE cur;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('producto_delete');
    }
};
