<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('cat_usuarios_delete', function ($trigger) {
            $trigger->on('cat_usuarios');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::DELETE);
            $trigger->statement(
                'DELETE FROM mov_changes
                WHERE tabla = \'USUARIOS\' AND identable = OLD.iduser;

                INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                VALUES (OLD.idsucursal, OLD.iduser, \'D\', \'USUARIOS\');'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('cat_usuarios_delete');
    }
};
