<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('mov_inv_detalle_insert_after', function ($trigger) {
            $trigger->on('mov_inv_detalle');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'DECLARE vIdSucursal BIGINT;
    DECLARE vManejaInventario INT;
    DECLARE vOrigenRegistro VARCHAR(15);
    DECLARE vEsProductoCompuesto INT;

    DECLARE vFechahoraRegistro TIMESTAMP;
    DECLARE vTipoMovimiento VARCHAR(20);
    DECLARE vSigno INT;
    DECLARE vUsuario VARCHAR(50);
    DECLARE vFromHost VARCHAR(50);
    DECLARE vOrigenMovimiento VARCHAR(50);
    DECLARE vOrigenIdMovimiento INT;
    DECLARE vOrigenFolio BIGINT;
    DECLARE vIdProducto BIGINT;
    DECLARE vExistenciaAnterior DECIMAL(18,6);
    DECLARE vNuevaExistencia DECIMAL(18,6);
    DECLARE vExistenciaFinal DECIMAL(18,6);
    DECLARE vIdTurno BIGINT;
    DECLARE vIdAlmacen BIGINT;
    DECLARE vComentarios VARCHAR(120);
    DECLARE vFisico DECIMAL(18,6);
    DECLARE vFaltante DECIMAL(18,6);
    DECLARE vExcedente DECIMAL(18,6);
    DECLARE vCostoPromedioSinIVA DECIMAL(18,6);
    DECLARE vImporte DECIMAL(18,6);

    DECLARE m_idcomponente BIGINT;
    DECLARE m_cantidad_componente DECIMAL(18,6);
    DECLARE m_manejainventario TINYINT;
    DECLARE m_costopromedio DECIMAL(18,6);
    DECLARE fin INT;

    DECLARE curComponentes CURSOR FOR
        SELECT c.idcomponente, c.cantidad, p.manejainventario, p.costo_promedio_antesiva
        FROM productoscompuestos AS c
        INNER JOIN cat_productos AS p ON c.idcomponente = p.idproduct
        WHERE c.idproducto = NEW.idproducto;

    DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin = 1;

    SET fin = 0;

    SELECT v.idsucursal, v.fechahora_registro, v.usuario, v.from_host, v.origen_movimiento, v.idturno, v.tipo_movimiento, v.signo
    FROM mov_inv_general v
    WHERE v.idmovinventariogral = NEW.idinventariofisicogral
    LIMIT 1
    INTO vIdSucursal, vFechahoraRegistro, vUsuario, vFromHost, vOrigenMovimiento, vIdTurno, vTipoMovimiento, vSigno;

    SELECT P.manejainventario, P.esproductocompuesto
    FROM cat_productos P
    WHERE P.idproduct = NEW.idproducto
    LIMIT 1
    INTO vManejaInventario, vEsProductoCompuesto;

    SET vFisico = 0;
    SET vFaltante = 0;
    SET vExcedente = 0;

    IF NEW.origen_registro = \'WEB\' THEN
        INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
        VALUES (NEW.idsucursal, NEW.idmovinventariodet, \'I\', \'INVENTARIOFISICODET\');
    END IF;

    IF vManejaInventario = 1 THEN
        SELECT i.existencia
        FROM mov_inv_existencias i
        WHERE i.idproducto = NEW.idproducto
          AND i.idsucursal = NEW.idsucursal -- AND i.idalmacen = NEW.idalmacen
        INTO vExistenciaAnterior;

        IF vExistenciaAnterior IS NOT NULL THEN
            IF vTipoMovimiento = \'INICIAL\' THEN
                SET vFisico = NEW.fisico;
                SET vFaltante = NEW.faltante;
                SET vExcedente = NEW.excedente;
                SET vExistenciaFinal = NEW.cantidad;
                SET vNuevaExistencia = vExistenciaFinal;
            ELSEIF vTipoMovimiento = \'ENTRADA\' THEN
                SET vExistenciaFinal = vExistenciaAnterior + NEW.cantidad;
                SET vNuevaExistencia = vExistenciaFinal;
            ELSEIF vTipoMovimiento = \'SALIDA\' THEN
                SET vExistenciaFinal = vExistenciaAnterior - NEW.cantidad;
                SET vNuevaExistencia = vExistenciaFinal;
            END IF;

            IF NEW.cantidad = 0 THEN
                SET vCostoPromedioSinIVA = 0;
            ELSE
                SET vCostoPromedioSinIVA = NEW.costoinventario / NEW.cantidad;
            END IF;

            INSERT INTO bitacora_existencias (
                idsucursal, idbitacora, fechahora_registro, tipo, signo, usuario, from_host, origen_movimiento,
                origen_idmovimiento, origen_folio, idproducto, existencia_anterior, movimiento_cantidad, existencia_final,
                idturno, idalmacen, comentarios, fisico, faltante, excedente, origen_registro, descargado, precio_unitario, importe
            ) VALUES (
                NEW.idsucursal, 0, vFechahoraRegistro, vTipoMovimiento, vSigno, vUsuario, vFromHost, vOrigenMovimiento,
                NEW.idinventariofisicogral, NEW.idinventariofisicogral, NEW.idproducto, vExistenciaAnterior,
                NEW.cantidad, vNuevaExistencia, vIdTurno, NEW.idalmacen, vOrigenMovimiento, vFisico, vFaltante,
                vExcedente, NEW.origen_registro, 0, vCostoPromedioSinIVA, NEW.costoinventario
            );

            UPDATE mov_inv_existencias i
            SET i.existencia = vNuevaExistencia
            WHERE i.idproducto = NEW.idproducto
              AND i.idsucursal = NEW.idsucursal;
        END IF;
    END IF;

    IF vEsProductoCompuesto = 1 THEN
        OPEN curComponentes;
        ins_loop: LOOP
            FETCH curComponentes INTO m_idcomponente, m_cantidad_componente, m_manejainventario, m_costopromedio;
            IF fin = 1 THEN LEAVE ins_loop; END IF;

            IF m_manejainventario = 1 THEN
                SELECT i.existencia
                FROM mov_inv_existencias i
                WHERE i.idproducto = m_idcomponente
                  AND i.idsucursal = NEW.idsucursal
                INTO vExistenciaAnterior;

                IF vExistenciaAnterior IS NOT NULL THEN
                    IF vTipoMovimiento = \'ENTRADA\' THEN
                        SET vExistenciaFinal = vExistenciaAnterior + (NEW.cantidad * m_cantidad_componente);
                        SET vNuevaExistencia = vExistenciaFinal;
                    ELSEIF vTipoMovimiento = \'SALIDA\' THEN
                        SET vExistenciaFinal = vExistenciaAnterior - (NEW.cantidad * m_cantidad_componente);
                        SET vNuevaExistencia = vExistenciaFinal;
                    END IF;

                    INSERT INTO bitacora_existencias (
                        idsucursal, idbitacora, fechahora_registro, tipo, signo, usuario, from_host, origen_movimiento,
                        origen_idmovimiento, origen_folio, idproducto, existencia_anterior, movimiento_cantidad, existencia_final,
                        idturno, idalmacen, comentarios, fisico, faltante, excedente, origen_registro, descargado, precio_unitario, importe
                    ) VALUES (
                        NEW.idsucursal, 0, vFechahoraRegistro, vTipoMovimiento, vSigno, vUsuario, vFromHost, vOrigenMovimiento,
                        NEW.idinventariofisicogral, NEW.idinventariofisicogral, m_idcomponente, vExistenciaAnterior,
                        (NEW.cantidad * m_cantidad_componente), vNuevaExistencia, vIdTurno, NEW.idalmacen, vOrigenMovimiento,
                        vFisico, vFaltante, vExcedente, NEW.origen_registro, 0, m_costopromedio,
                        m_costopromedio * (NEW.cantidad * m_cantidad_componente)
                    );

                    UPDATE mov_inv_existencias i
                    SET i.existencia = vNuevaExistencia
                    WHERE i.idproducto = m_idcomponente
                      AND i.idsucursal = NEW.idsucursal;
                END IF;
            END IF;
        END LOOP;
        CLOSE curComponentes;
    END IF;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('mov_inv_detalle_insert_after');
    }
};
