<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('pedidos_intermedios_general_movil_AI', function ($trigger) {
            $trigger->on('pedidos_intermedios_general_movil');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::INSERT);
            $trigger->statement(
                'INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                VALUES (NEW.idsucursal, NEW.id, \'I\', \'PEDIDOS_INTERMEDIOS_GENERAL_MOVIL\');'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('pedidos_intermedios_general_movil_AI');
    }
};
