<?php

use Esign\DatabaseTrigger\Enums\TriggerEvent;
use Esign\DatabaseTrigger\Enums\TriggerTiming;
use Esign\DatabaseTrigger\Facades\Schema;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    public function up(): void
    {
        Schema::createTrigger('cat_conceptosinventarios_delete', function ($trigger) {
            $trigger->on('cat_conceptosinventarios');
            $trigger->timing(TriggerTiming::AFTER);
            $trigger->event(TriggerEvent::DELETE);
            $trigger->statement(
                'DECLARE m_idsucursal INT;
                DECLARE fin int;
                DECLARE cur CURSOR FOR SELECT idsucursal FROM cat_sucursales;
                DECLARE CONTINUE HANDLER FOR NOT FOUND SET fin=1;

                DELETE FROM mov_changes
                WHERE tabla = \'CONCEPTOSINVENTARIOS\' AND identable = OLD.idinventoryconcept;

                OPEN cur;
                  ins_loop: LOOP
                    FETCH cur INTO m_idsucursal;
                    IF fin=1 THEN
                      LEAVE ins_loop;
                    END IF;
                    INSERT INTO mov_changes (idsucursal, identable, accion, tabla)
                    VALUES (m_idsucursal, OLD.idinventoryconcept, \'D\', \'CONCEPTOSINVENTARIOS\');
                  END LOOP;
                CLOSE cur;'
            );
        });
    }

    public function down(): void
    {
        Schema::dropTriggerIfExists('cat_conceptosinventarios_delete');
    }
};
