<div>
    @script
        <script>
            $wire.on('confirmar-eliminacion', (params) => {
                console.log('Parámetros recibidos:', params);
                Swal.fire({
                    title: "¿Estás seguro?",
                    text: "Esto es irreversible",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: "#3085d6",
                    cancelButtonColor: "#d33",
                    confirmButtonText: "Sí, eliminarlo",
                    cancelButtonText: "No, cancelar"
                }).then((result) => {
                    if (result.isConfirmed) {
                        $wire.dispatch('delete', {id: params[0].id});
                        Swal.fire({
                            title: "¡Eliminado!",
                            text: params[0].successText || "La operación se completó.",
                            icon: "success"
                        });
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                        Swal.fire({
                            title: "Cancelado",
                            text: "La entidad no ha sido eliminada.",
                            icon: "error"
                        });
                    }
                });
            });
        </script>
    @endscript
</div>
