@props(['label', 'align' => 'left   '])

<div x-data="{ open: false }" class="relative inline-block text-left">
    <button @click="open = !open" type="button"
        class="inline-flex items-center px-4 py-2 bg-white text-sm font-medium text-gray-700 hover:bg-gray-50 border border-gray-300 rounded-md shadow-sm">
        {{ $label }}
        <svg class="ml-2 w-4 h-4" xmlns="http://www.w3.org/2000/svg" fill="none"
            viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <div x-show="open" @click.away="open = false"
        class="absolute z-10 mt-2 w-56 rounded-md shadow-lg bg-white ring-1 ring-black ring-opacity-5 {{ $align === 'right' ? 'right-0 origin-top-right' : 'left-0 origin-top-left' }}"
        style="display: none;">
        <div class="py-1 text-sm text-gray-700">
            {{ $slot }}
        </div>
    </div>
</div>
