@props(['header', 'headerValues', 'overflowY' => ''])

<div>
    <div class="w-full xl:w-full mb-12 sm:mb-0 mx-auto mt-4">
        <div class="relative flex flex-col min-w-0 break-words bg-white w-full mb-6 shadow-lg rounded">
            <div class="rounded-t mb-0 px-4 py-3 border-0">
                <div class="flex flex-wrap items-center justify-between">
                    <div class="relative w-full px-4 max-w-full flex-grow flex-1">
                        <h3 class="font-semibold text-base text-blueGray-700">
                            {{ $header }}
                        </h3>
                    </div>
                    <div class="px-4 flex-0 text-right">
                        @if (isset($headerAction))
                            {{ $headerAction }}
                        @endif
                    </div>
                </div>
            </div>

            <div class="block w-full overflow-x-auto {{$overflowY}}">
                <table class="items-center bg-transparent w-full border-collapse">
                    <thead class="sticky top-0 left-0 bg-white">
                        <tr>
                            @foreach ($headerValues as $header)
                                <th
                                    class="px-6 bg-blueGray-50 text-blueGray-500 align-middle border border-solid border-blueGray-100 py-3 text-xs uppercase border-l-0 border-r-0 whitespace-nowrap font-semibold text-left">
                                    {{ $header }}</th>
                            @endforeach
                        </tr>
                    </thead>

                    <tbody class="w-full">
                        @if (isset($body))
                            {{ $body }}
                        @else
                            <tr>
                                <x-generic-table.cell colspan="{{ count($headerValues) }}">
                                    No hay datos disponibles.
                                </x-generic-table.cell>
                            </tr>
                        @endif

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
