@props(['type' => 'text','label', 'id', 'error', 'placeholder' => '', 'variant' => 'default'])

@php
    $baseClass = 'block w-full rounded-sm bg-gray-100 px-2 py-1 text-sm text-gray-900 outline-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2';
    $variantClass = '';
    if ($variant === 'default') {
        $variantClass = 'bg-white focus:outline-indigo-600';
    } elseif($variant === 'ghost') {
        $variantClass = 'bg-zinc-800/5';
    }
@endphp
<div>
    <label for="{{ $id }}" class="block text-sm font-medium text-gray-900">{{ $label }}</label>
    <div class="mt-2">
        <input wire:key="{{$id}}-{{$label}}" type="{{$type}}" placeholder="{{ $placeholder }}"
        {{ $attributes->merge(['class' => "$variantClass $baseClass]"]) }}
        />
    </div>
    @if (isset($error))
        @error($error) <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
    @else
        @if (null !== $attributes->whereStartsWith('wire:model')->first())
             @error($attributes->whereStartsWith('wire:model')->first()) <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
        @endif
    @endif
</div>
