@props(['label', 'id', 'error', 'options' => [], 'placeholder' => 'Selecciona una opción'])
<div>
    <label for="{{ $id }}" class="block text-sm font-medium text-gray-900">{{ $label }}</label>
    <div class="mt-1">
        <select id="{{ $id }}" {{ $attributes->merge(['class' => "block w-full rounded-md bg-white px-2 py-1 text-sm text-gray-900 outline-1 outline-gray-300 focus:outline-2 focus:outline-indigo-600"]) }}>
            <option value="">{{ $placeholder }}</option>
            @foreach ($options as $value => $text)
                <option value="{{ $value }}">{{ $text }}</option>
            @endforeach
        </select>
    </div>
    @if (isset($error))
        @error($error) <span class="text-red-500 text-xs">{{ $message }}</span> @enderror
    @endif
</div>