@props(['label', 'id', 'error', 'placeholder' => ''])
<div>
    <label for="{{ $id }}" class="block text-sm font-medium text-gray-900">{{ $label }}</label>
    <div class="mt-1">
        
        <textarea wire:key="{{rand()}}" id="{{ $id }}"  name="{{ $id }}" placeholder="{{ $placeholder }}"
        
        {{ $attributes->merge(['class' => "block w-full resize-none rounded-md bg-white px-2 py-1 text-sm text-gray-900 outline-1 outline-gray-300 placeholder:text-gray-400 focus:outline-2 focus:outline-indigo-600"]) }}
        ></textarea>
    </div>
    @if (isset($error))
        @error($error) <span class="text-red-500 text-xs">{{ $message }}</span> @enderror

    @endif
</div>
