<table>
    <thead>
        <tr>
            <th colspan="12" style="text-align: center; font-size: 16px; font-weight: bold;">
                REPORTE DE CORTES DE CAJA
            </th>
        </tr>
        <tr>
            <th colspan="12" style="text-align: center;">
                @if(!empty($filtros['fechaInicio']) && !empty($filtros['fechaFin']))
                    Período: {{ \Carbon\Carbon::parse($filtros['fechaInicio'])->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($filtros['fechaFin'])->format('d/m/Y') }}
                @endif
            </th>
        </tr>
        <tr></tr>
        <tr style="background-color: #E2E8F0; font-weight: bold;">
            <th>Turno</th>
            <th>Fecha apertura</th>
            <th>Cerrado</th>
            <th>Fecha cierre</th>
            <th>Hrs. trabajadas</th>
            <th>Ingresos</th>
            <th>Egresos</th>
            <th>Ingresos - Egresos</th>
            <th>Corte empleado</th>
            <th>Diferencia</th>
            <th>Usuario</th>
            <th>Sucursal</th>
        </tr>
    </thead>
    <tbody>
        @foreach($cortes as $corte)
            <tr>
                <td>{{ $corte->idturno }}</td>
                <td>{{ $corte->fechahora_apertura ? \Carbon\Carbon::parse($corte->fechahora_apertura)->format('d/m/Y H:i') : 'N/A' }}</td>
                <td>{{ $corte->turno_cerrado ? 'Sí' : 'No' }}</td>
                <td>{{ $corte->fechahora_cierre ? \Carbon\Carbon::parse($corte->fechahora_cierre)->format('d/m/Y H:i') : 'N/A' }}</td>
                <td>
                    @if($corte->fechahora_apertura && $corte->fechahora_cierre)
                        {{ round(\Carbon\Carbon::parse($corte->fechahora_apertura)->diffInHours(\Carbon\Carbon::parse($corte->fechahora_cierre)), 2) }}
                    @else
                        N/A
                    @endif
                </td>
                <td style="text-align: right;">${{ number_format($corte->ingresos ?? 0, 2) }}</td>
                <td style="text-align: right;">${{ number_format($corte->egresos ?? 0, 2) }}</td>
                <td style="text-align: right;">${{ number_format(($corte->ingresos ?? 0) - ($corte->egresos ?? 0), 2) }}</td>
                <td style="text-align: right;">${{ number_format($corte->total_corte ?? 0, 2) }}</td>
                <td style="text-align: right;">${{ number_format(($corte->total_corte ?? 0) - (($corte->ingresos ?? 0) - ($corte->egresos ?? 0)), 2) }}</td>
                <td>{{ $corte->usuario }}</td>
                <td>{{ $corte->sucursal ?? 'N/A' }}</td>
            </tr>
        @endforeach
        <tr></tr>
        <tr style="font-weight: bold; background-color: #F3F4F6;">
            <td colspan="5">TOTALES</td>
            <td style="text-align: right;">${{ number_format($totales['total_ingresos'] ?? 0, 2) }}</td>
            <td style="text-align: right;">${{ number_format($totales['total_egresos'] ?? 0, 2) }}</td>
            <td style="text-align: right;">${{ number_format(($totales['total_ingresos'] ?? 0) - ($totales['total_egresos'] ?? 0), 2) }}</td>
            <td style="text-align: right;">${{ number_format($totales['total_cortes'] ?? 0, 2) }}</td>
            <td style="text-align: right;">${{ number_format($totales['diferencia'] ?? 0, 2) }}</td>
            <td colspan="2"></td>
        </tr>
    </tbody>
</table>
