<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Catálogo de Marcas</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 12px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        h1 {
            font-size: 20px;
            margin: 0;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .table th {
            background-color: #f2f2f2;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Catálogo de Marcas</h1>
        <p>Reporte generado el: {{ date('d/m/Y H:i:s') }}</p>
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Clave</th>
                <th>Marca</th>
                <th>Comentario</th>
            </tr>
        </thead>
        <tbody>
            @forelse($marcas as $marca)
                <tr>
                    <td>{{ $marca->idmarca }}</td>
                    <td>{{ $marca->clave }}</td>
                    <td>{{ $marca->marca }}</td>
                    <td>{{ $marca->comentarios }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="4" style="text-align: center;">No hay marcas que coincidan con la búsqueda.</td>
                </tr>
            @endforelse
        </tbody>
    </table>
</body>
</html>
