<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Comprobante de Venta</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
            margin: 0;
            padding: 20px;
            line-height: 1.2;
        }
        
        .header {
            width: 100%;
            margin-bottom: 20px;
            position: relative;
        }
        
        .title-section {
            text-align: left;
            margin-bottom: 15px;
        }
        
        .title-section h1 {
            font-size: 14px;
            font-weight: bold;
            margin: 0;
            letter-spacing: 2px;
        }
        
        .header-info {
            position: absolute;
            right: 0;
            top: 0;
            font-size: 10px;
        }
        
        .header-info div {
            margin-bottom: 2px;
        }
        
        .main-content {
            width: 100%;
            margin-bottom: 15px;
            overflow: hidden;
        }
        
        .left-column {
            float: left;
            width: 48%;
            margin-right: 2%;
            margin-bottom: 15px;
        }
        
        .right-column {
            float: right;
            width: 48%;
            margin-left: 2%;
            margin-bottom: 15px;
        }
        
        .info-section {
            margin-bottom: 15px;
        }
        
        .info-section h3 {
            font-size: 10px;
            font-weight: bold;
            margin: 0 0 5px 0;
            padding: 3px 0;
            border-bottom: 1px solid #000;
        }
        
        .info-section p {
            margin: 2px 0;
            font-size: 9px;
        }
        
        .products-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 8px;
        }
        
        .products-table th {
            background-color: #f0f0f0;
            border: 1px solid #000;
            padding: 4px;
            text-align: center;
            font-weight: bold;
            font-size: 8px;
        }
        
        .products-table td {
            border: 1px solid #000;
            padding: 3px;
            text-align: center;
            font-size: 8px;
        }
        
        .products-table td.description {
            text-align: left;
            max-width: 200px;
            word-wrap: break-word;
        }
        
        .products-table td.number {
            text-align: right;
        }
        
        .totals-section {
            float: right;
            width: 40%;
            margin-top: 10px;
        }
        
        .totals-table {
            width: 100%;
            border-collapse: collapse;
            font-size: 9px;
        }
        
        .totals-table td {
            padding: 3px 8px;
            border-bottom: 1px solid #ccc;
        }
        
        .totals-table td:first-child {
            text-align: left;
            font-weight: bold;
        }
        
        .totals-table td:last-child {
            text-align: right;
        }
        
        .total-final {
            font-size: 11px;
            font-weight: bold;
            border-top: 2px solid #000 !important;
            border-bottom: 2px solid #000 !important;
        }
        
        .total-letras {
            margin-top: 15px;
            font-size: 8px;
            font-style: italic;
            text-align: center;
            padding: 8px;
            border: 1px solid #000;
            background-color: #f9f9f9;
        }
        
        .clearfix {
            clear: both;
        }
        
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 8px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="title-section">
            <h1>COMPROBANTE DE VENTA</h1>
        </div>
        <div class="header-info">
            <div><strong>Folio:</strong> {{ $folio }}</div>
            <div><strong>Fecha:</strong> {{ $fecha }}</div>
        </div>
    </div>

    <div class="main-content">
        <div class="left-column">
            <div class="info-section">
                <h3>DATOS DE LA EMPRESA</h3>
                <p><strong>{{ $empresa['razon_social'] }}</strong></p>
                <p><strong>RFC:</strong> {{ $empresa['rfc'] }}</p>
                <p><strong>Dirección:</strong> {{ $empresa['direccion'] }}</p>
                <p><strong>Ciudad:</strong> {{ $empresa['ciudad'] }}</p>
                <p><strong>C.P.:</strong> {{ $empresa['cp'] }}</p>
                <p><strong>Teléfono:</strong> {{ $empresa['telefono'] }}</p>
                <p><strong>Lugar de Expedición:</strong> {{ $empresa['lugar_expedicion'] }}</p>
                <p><strong>Régimen Fiscal:</strong> {{ $empresa['regimen_fiscal'] }}</p>
            </div>
        </div>
        
        <div class="right-column">
            <div class="info-section">
                <h3>DATOS DEL CLIENTE</h3>
                <p><strong>{{ $cliente['nombre'] }}</strong></p>
                <p><strong>RFC:</strong> {{ $cliente['rfc'] ?? 'XAXX010101000' }}</p>
                @if(!empty($cliente['direccion']))
                    <p><strong>Dirección:</strong> {{ $cliente['direccion'] }}</p>
                @endif
                @if(!empty($cliente['cp']))
                    <p><strong>C.P.:</strong> {{ $cliente['cp'] }}</p>
                @endif
                <p><strong>Régimen Fiscal:</strong> {{ $cliente['regimen_fiscal'] ?? '621|Incorporación Fiscal' }}</p>
            </div>
        </div>
    </div>

    <div class="clearfix"></div>

    <table class="products-table">
        <thead>
            <tr>
                <th style="width: 8%;">CANT.</th>
                <th style="width: 8%;">UNIDAD</th>
                <th style="width: 12%;">CLAVE</th>
                <th style="width: 42%;">DESCRIPCIÓN</th>
                <th style="width: 15%;">PRECIO UNIT.</th>
                <th style="width: 15%;">TOTAL</th>
            </tr>
        </thead>
        <tbody>
            @foreach($productos as $producto)
                <tr>
                    <td class="number">{{ number_format($producto['cantidad'], 2) }}</td>
                    <td>{{ $producto['unidad'] ?? 'PZA' }}</td>
                    <td>{{ $producto['clave'] }}</td>
                    <td class="description">{{ $producto['descripcion'] }}</td>
                    <td class="number">${{ number_format($producto['precio_unitario'], 2) }}</td>
                    <td class="number">${{ number_format($producto['total'], 2) }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="totals-section">
        <table class="totals-table">
            <thead>
                <tr>
                    <th>Concepto</th>
                    <th>Importe</th>
                </tr>
            </thead>
            <tbody>
                <tr class="total-final">
                    <td>TOTAL:</td>
                    <td>${{ number_format($totales['total'], 2) }}</td>
                </tr>
            </tbody>
        </table>
    </div>

    <div class="clearfix"></div>

    @if(!empty($total_letras))
        <div class="total-letras">
            <strong>TOTAL EN LETRAS:</strong> {{ $total_letras }}
        </div>
    @endif

    <div class="footer">
        <p>*** COMPROBANTE DE VENTA - DOCUMENTO SIN VALIDEZ FISCAL ***</p>
        <p>Generado el {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>
</body>
</html>
