<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reporte de Ventas por {{ $tipoVenta === 'familia' ? 'Familia' : 'Producto' }}</title>
    <style>
        body {
            font-family: 'Helvetica', sans-serif;
            font-size: 11px;
            margin: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 10px;
        }
        h1 {
            font-size: 18px;
            margin: 0 0 10px 0;
            color: #333;
        }
        .info {
            font-size: 10px;
            color: #666;
        }
        .filters {
            background-color: #f9f9f9;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ddd;
            font-size: 10px;
        }
        .filters strong {
            color: #333;
        }
        .table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .table th, .table td {
            border: 1px solid #ddd;
            padding: 6px 8px;
            text-align: left;
        }
        .table th {
            background-color: #4a5568;
            color: white;
            font-weight: bold;
            font-size: 10px;
        }
        .table td {
            font-size: 10px;
        }
        .table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        .text-right {
            text-align: right;
        }
        .totals {
            background-color: #e2e8f0;
            font-weight: bold;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 9px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Reporte de Ventas por {{ $tipoVenta === 'familia' ? 'Familia' : 'Producto' }}</h1>
        <p class="info">Reporte generado el: {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>

    <div class="filters">
        <strong>Filtros aplicados:</strong><br>
        Fecha: {{ \Carbon\Carbon::parse($fechainicial)->format('d/m/Y') }} - {{ \Carbon\Carbon::parse($fechafinal)->format('d/m/Y') }}<br>
        @if($sucursal)
            Sucursal: {{ $sucursal }}<br>
        @endif
        @if($familia)
            Familia: {{ $familia }}<br>
        @endif
        @if($usuario)
            Usuario: {{ $usuario }}<br>
        @endif
        @if($turnosInfo)
            {{ $turnosInfo }}<br>
        @endif
    </div>

    <table class="table">
        <thead>
            <tr>
                <th>{{ $tipoVenta === 'familia' ? 'Familia' : 'Producto' }}</th>
                <th class="text-right">Cantidad</th>
                <th class="text-right">Costo</th>
                <th class="text-right">Subtotal</th>
                <th class="text-right">IVA</th>
                <th class="text-right">Total</th>
                <th class="text-right">Utilidad</th>
            </tr>
        </thead>
        <tbody>
            @forelse($data as $item)
                <tr>
                    <td>{{ $item->nombre }}</td>
                    <td class="text-right">{{ number_format($item->cantidad, 2) }}</td>
                    <td class="text-right">${{ number_format($item->costo, 2) }}</td>
                    <td class="text-right">${{ number_format($item->subtotal, 2) }}</td>
                    <td class="text-right">${{ number_format($item->iva, 2) }}</td>
                    <td class="text-right">${{ number_format($item->total, 2) }}</td>
                    <td class="text-right">${{ number_format($item->utilidad, 2) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="7" style="text-align: center;">No hay datos para mostrar</td>
                </tr>
            @endforelse
        </tbody>
        <tfoot>
            <tr class="totals">
                <td><strong>TOTALES</strong></td>
                <td class="text-right"><strong>{{ number_format($totales['cantidad'], 2) }}</strong></td>
                <td class="text-right"><strong>${{ number_format($totales['costo'], 2) }}</strong></td>
                <td class="text-right"><strong>${{ number_format($totales['subtotal'], 2) }}</strong></td>
                <td class="text-right"><strong>${{ number_format($totales['iva'], 2) }}</strong></td>
                <td class="text-right"><strong>${{ number_format($totales['total'], 2) }}</strong></td>
                <td class="text-right"><strong>${{ number_format($totales['utilidad'], 2) }}</strong></td>
            </tr>
        </tfoot>
    </table>

    <div class="footer">
        <p>Página {PAGENO} de {nbpg}</p>
    </div>
</body>
</html>
