<?php

use Illuminate\Support\Facades\Password;
use Livewire\Attributes\Layout;
use Livewire\Volt\Component;

new #[Layout('components.layouts.auth')] class extends Component {
    public string $email = '';

    /**
     * Send a password reset link to the provided email address.
     */
    public function sendPasswordResetLink(): void
    {
        $this->validate([
            'email' => ['required', 'string', 'email'],
        ]);

        Password::sendResetLink($this->only('email'));

        session()->flash('status', __('A reset link will be sent if the account exists.'));
    }
}; ?>

<div class="custom-login-container">
    <style>
    /* Desactivar barra de progreso de Livewire completamente */
    [wire\:loading-bar],
    [x-cloak] [wire\:loading],
    .livewire-progress-bar,
    div[x-data*="livewireLoadingBar"],
    div[style*="position: fixed"][style*="height: 2px"],
    div[style*="position: fixed"][style*="height: 3px"] {
        display: none !important;
        visibility: hidden !important;
        opacity: 0 !important;
    }

    /* Sobrescribir todos los estilos restrictivos del layout */
    .bg-background,
    .flex.min-h-svh,
    .flex.w-full.max-w-sm {
        max-width: none !important;
        width: 100% !important;
    }

    body > div > div,
    body > div > div > div {
        max-width: none !important;
        width: 100% !important;
        gap: 0 !important;
    }

    .custom-login-container {
        background: white;
        border-radius: 20px;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
        overflow: hidden;
        max-width: 900px !important;
        width: 100% !important;
        display: grid;
        grid-template-columns: 1fr 1fr;
        margin: 0 auto;
    }

    .custom-login-left {
        background: linear-gradient(135deg, #1e3a8a 0%, #3b82f6 100%);
        padding: 60px 40px;
        color: white;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        text-align: center;
    }

    .custom-login-left h1 {
        font-size: 2.5em;
        margin-bottom: 20px;
        font-weight: 700;
    }

    .custom-login-left p {
        font-size: 1.1em;
        opacity: 0.9;
        line-height: 1.6;
    }

    .custom-logo {
        width: 150px;
        height: auto;
        margin-bottom: 30px;
    }

    .custom-login-right {
        padding: 60px 40px;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .custom-login-right h2 {
        color: #1e3a8a;
        font-size: 2em;
        margin-bottom: 10px;
    }

    .custom-login-right .custom-subtitle {
        color: #64748b;
        margin-bottom: 40px;
        font-size: 0.95em;
    }

    .custom-form-group {
        margin-bottom: 25px;
    }

    .custom-form-group label {
        display: block;
        color: #334155;
        font-weight: 600;
        margin-bottom: 8px;
        font-size: 0.9em;
    }

    .custom-input-wrapper {
        position: relative;
    }

    .custom-input-wrapper svg {
        position: absolute;
        left: 15px;
        top: 50%;
        transform: translateY(-50%);
        width: 20px;
        height: 20px;
        color: #64748b;
    }

    .custom-form-group input {
        width: 100%;
        padding: 14px 14px 14px 45px;
        border: 2px solid #e2e8f0;
        border-radius: 10px;
        font-size: 0.95em;
        transition: all 0.3s ease;
        outline: none;
    }

    .custom-form-group input:focus {
        border-color: #f97316;
        box-shadow: 0 0 0 3px rgba(249, 115, 22, 0.1);
    }

    .custom-login-button {
        width: 100%;
        padding: 16px;
        background: linear-gradient(135deg, #f97316 0%, #fb923c 100%);
        color: white;
        border: none;
        border-radius: 10px;
        font-size: 1em;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(249, 115, 22, 0.3);
    }

    .custom-login-button:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(249, 115, 22, 0.4);
    }

    .custom-login-button:active {
        transform: translateY(0);
    }

    .custom-back-link {
        text-align: center;
        margin-top: 25px;
        color: #64748b;
        font-size: 0.9em;
    }

    .custom-back-link a {
        color: #3b82f6;
        text-decoration: none;
        font-weight: 600;
        transition: color 0.3s ease;
    }

    .custom-back-link a:hover {
        color: #1e3a8a;
    }

    .custom-error-message {
        color: #dc2626;
        font-size: 0.85em;
        margin-top: 5px;
    }

    .custom-success-message {
        background: #dcfce7;
        color: #166534;
        padding: 12px 16px;
        border-radius: 10px;
        font-size: 0.9em;
        margin-bottom: 25px;
        border: 1px solid #bbf7d0;
    }

    @media (max-width: 768px) {
        .custom-login-container {
            grid-template-columns: 1fr;
        }

        .custom-login-left {
            padding: 40px 30px;
        }

        .custom-login-left h1 {
            font-size: 2em;
        }

        .custom-login-right {
            padding: 40px 30px;
        }
    }
</style>
    <div class="custom-login-left">
        <img src="{{ asset('imagenes/logo_enkelt.avif') }}" alt="Logo" class="custom-logo">
        <h1>¿Olvidaste tu contraseña?</h1>
        <p>No te preocupes, te enviaremos un enlace para restablecer tu contraseña de forma segura.</p>
    </div>

    <div class="custom-login-right">
        <h2>Recuperar Contraseña</h2>
        <p class="custom-subtitle">Ingresa tu correo electrónico para recibir el enlace</p>

        <!-- Session Status -->
        @if (session('status'))
            <div class="custom-success-message">
                {{ session('status') }}
            </div>
        @endif

        <form wire:submit="sendPasswordResetLink">
            <!-- Email Address -->
            <div class="custom-form-group">
                <label for="email">{{ __('E-mail') }}</label>
                <div class="custom-input-wrapper">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
                    </svg>
                    <input 
                        type="email" 
                        id="email" 
                        wire:model="email"
                        required
                        autofocus
                    >
                </div>
                @error('email')
                    <div class="custom-error-message">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="custom-login-button" wire:loading.attr="disabled">
                <span wire:loading.remove>{{ __('Enviar link para restablecer contraseña') }}</span>
                <span wire:loading>Enviando enlace...</span>
            </button>

            <div class="custom-back-link">
                {{ __('O, regresar a') }} 
                <a href="{{ route('login') }}" wire:navigate>{{ __('iniciar sesión') }}</a>
            </div>
        </form>
    </div>
</div>
