<div class="p-4 gap-4">
    <input wire:model.live.debounce.500ms="search" type="text" placeholder="Buscar Marcas por clave o concepto"
        class="rounded-lg border p-2 w-full shadow-md" />
    <x-generic-table header="Listado de conceptos" :headerValues="$headerValues" :showActions="true">
        @slot('headerAction')
            <x-button wire:click="create">Crear nuevo concepto</x-button>
        @endslot

        @slot('body')
            @foreach ($conceptos as $concepto)
                <tr wire:key="concepto-{{$concepto->idinventoryconcept}}">
                    <x-generic-table.cell>{{ $concepto->idinventoryconcept }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->idempresa }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->idconceptoinventario }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->clave }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->conceptoinventario }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->idaccion }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->signo }}</x-generic-table.cell>
                    <x-generic-table.cell>{{ $concepto->editable }}</x-generic-table.cell>

                    
                    <x-generic-table.cell>
                        <flux:button wire:click="edit({{ $concepto->idinventoryconcept }})">Editar</flux:button>
                        <flux:button wire:click="confirmdelete({{ $concepto->idinventoryconcept }})" variant="danger">
                            Eliminar
                        </flux:button>
                    </x-generic-table.cell>
                </tr>
            @endforeach
        @endslot
    </x-generic-table>

    <div>
        {{ $conceptos->links() }}
    </div>
    <x-confirm-delete />
</div>
