<div class="flex flex-col gap-8 sm:col-span-3">
    <x-input-label id="clave" wire:model.live.debounce.500ms="form.clave" label="Clave (*)" placeholder="Clave"
        class="{{ $isClaveAvailable === null && $isClaveAvailable === false ? '!outline-red-500 !outline-2' : '' }}" />
    <x-input-label id="nombrecorto" wire:model="form.nombrecorto" label="Nombre corto (*)" />
    <x-textarea-label id="descripcion" wire:model="form.descripcion" label="Descripción (*)" error="form.descripcion"/>

    <div class="flex flex-row gap-4 items-center">
        <span class="!font-normal">Familia:</span>
        <flux:select wire:model='form.idfamilia' placeholder="Selecciona una familia" size="sm">
            @foreach ($families as $family)
                <option value="{{ $family['idfamily'] }}">{{ $family['nombrefamilia'] }}</option>
            @endforeach
        </flux:select>

        <span class="!font-normal">Marca:</span>
        <flux:select wire:model='form.idmarca' placeholder="Selecciona una marca" size="sm">
            @foreach ($brands as $brand)
                <option value="{{ $brand['idbrand'] }}">{{ $brand['marca'] }}</option>
            @endforeach
        </flux:select>
    </div>
</div>
<div class="flex flex-col gap-4 sm:col-span-3">
    <flux:input type="file" label="Imagen del producto" wire:model.live="form.imagen"
        accept=".JPG, .JPEG, .PNG, .GIF, .WebP" />

    <div class="h-[9.9em] w-full border">
        @if ($form['imagen'])
            <img src="{{ method_exists($form['imagen'], 'temporaryUrl') ? $form['imagen']->temporaryUrl() : route('private.image', ['path' => $form['imagen']]) }}" alt="producto_img" class="h-[9.8em]">
        @else
            <img src="{{ asset('imagenes/default_producto.png') }}" alt="default_img"
                class="h-[9.9em] w-full" />
        @endif
    </div>
    <x-label>Código de barras:</x-label>
    <flux:button.group>
        <x-label class="w-full bg-gray-100 rounded-l-lg p-2">
            {{ $form['codigodebarras'] == '' ? 'Sin código' : $form['codigodebarras'] }}
        </x-label>
        <flux:modal.trigger name="codigo-barras">
            <flux:button class="!hover:bg-green-50" icon="plus" icon:variant="solid" square />
        </flux:modal.trigger>
        <flux:button type="button" wire:click="$set('form.codigodebarras', '')" icon="x-mark" icon:variant="solid"
            square />
    </flux:button.group>
    <div class="flex h-[3.9em] border items-center justify-center">
        @if ($barcodeImage && $form['codigodebarras'] != '')
            <img src="data:image/png;base64,{{ $barcodeImage }}" alt="barcode">
        @endif
    </div>
</div>
<div class="sm:col-span-2">
    <flux:field>
        <flux:label>Clave Producto-Servicio</flux:label>
        <flux:input.group>
            <flux:input wire:model="form.clave_prodserv" readonly size="sm"
                placeholder="clave_producto_servicio" />
            <flux:modal.trigger name="producto-servicio">
                <flux:button size="sm" icon="magnifying-glass" />
            </flux:modal.trigger>

        </flux:input.group>
    </flux:field>
</div>
<div class="sm:col-span-2">
    <x-input-label wire:model="form.clave_prodserv" readonly id="clave_producto_servicio"
        label="Clave Producto/Servicio" />
</div>
<div class="sm:col-span-2">
    <x-input-label wire:model="form.prodserv" readonly id="clave_producto_servicio"
        label="Descripción Producto/Servicio" />
</div>
<div class="sm:col-span-2">
    <flux:field>
        <flux:label>Unidad de medida</flux:label>
        <flux:input.group>
            <flux:input readonly wire:model="form.clave_unidadmedida" size="sm" placeholder="H87" />
            <flux:modal.trigger name="unidad-medida">
                <flux:button size="sm" icon="magnifying-glass" />
            </flux:modal.trigger>

        </flux:input.group>
    </flux:field>
</div>
<div class="sm:col-span-2">
    <x-input-label wire:model="form.clave_unidadmedida" readonly id="clave_producto_servicio"
        label="Clave Unidad de medida" />
</div>
<div class="sm:col-span-2">
    <x-input-label wire:model="form.unidadmedida" readonly id="clave_producto_servicio"
        label="Descripción Unidad de medida" />
</div>
<div class="sm:col-span-2 flex flex-col gap-4">
    <flux:checkbox wire:model.live="form.habilitar_pesaje" label="Habilitar pesaje" />
    @if ($form['habilitar_pesaje'] == true)
        <flux:input.group>
            <flux:input type="number" size="sm" placeholder="Ingresa la cantidad en gramos" />

            <flux:input.group.suffix>gramos</flux:input.group.suffix>
        </flux:input.group>
    @endif
    <flux:checkbox wire:model="form.manejainventario" label="Maneja inventarios" />
    <flux:checkbox wire:model="form.manejanumeroserie" label="Maneja número de series" />
    <flux:checkbox wire:model="form.manejacaducidad" label="Maneja CADUCIDAD" />

</div>
<div class="sm:col-span-2 flex flex-col gap-4">
    <flux:checkbox wire:model.live="form.esproductocompuesto" label="Es producto compuesto" />
    <flux:modal.trigger name="producto-componentes">
        <flux:button id="button-compuesto" type="button" variant="primary"
            :disabled="$form['esproductocompuesto'] == false">Definir componentes</flux:button>
    </flux:modal.trigger>

    <flux:checkbox wire:model.live="form.manejainsumos" label="Manjea insumos" />
</div>
<div class="sm:col-span-2 flex flex-col gap-4">
    <flux:checkbox wire:model="form.productoactivo" label="Producto activo" />
    <flux:checkbox wire:model="form.productoexclusivo" label="Producto exclusivo" />
    <flux:checkbox wire:model="form.esvisibleenventas" label="Visible en ventas" />
    <flux:checkbox wire:model="form.leerbascula" label="Obtener lectura de báscula" />
    <flux:checkbox wire:model="form.obtener_datos_from_cbb" label="Obtener etiqueta CBB" />
    <flux:checkbox wire:model="form.aplicar_tipodecambio" label="Aplicar tarifa de cambio" />
</div>
