<div class="sm:col-span-6">
    <x-generic-table header="" overflowY="overflow-scroll max-h-96" :headerValues="[
        'Fecha y hora registro',
        'Existencia anterior',
        'Movimiento cantidad',
        'Existencia final',
        'Usuario',
        'FromHost',
        'Origen movimiento',
        'Sucursal',
    ]">
        @slot('body')
            @if (isset($items))
                @if (count($items) > 0)
                    @foreach ($items as $item)
                        <tr>
                            <x-generic-table.cell>
                                {{ $item->fechahora_registro }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->existencia_anterior }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->movimiento_cantidad }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->existencia_final }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->usuario }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->from_host }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->origen_movimiento }}
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                {{ $item->sucursal?->razon_social ?? 'Error' }}
                            </x-generic-table.cell>
                        </tr>
                    @endforeach
                @else
                    <tr>
                        <x-generic-table.cell colspan="8">
                            No se encontraron datos con los filtros actuales.
                        </x-generic-table.cell>
                    </tr>
                @endif
            @else
                <tr>
                    <x-generic-table.cell colspan="8">
                        Ingresa los filtros y presiona el botón 'Buscar'.
                    </x-generic-table.cell>
                </tr>
            @endif

        @endslot
    </x-generic-table>
    @if (isset($items))
        
    @endif
</div>
<span wire:key="historico-{{ $model }}-total" class="sm:col-span-2">Total de registros:
    {{ $this->{$model}['total'] }}</span>

<span wire:key="historico-{{ $model }}-sumatoria" class="sm:col-span-2">Sumatoria:
    {{ $this->{$model}['sumatoria'] }}</span>

<flux:button type="button" wire:key="hisorico-{{ $model }}" wire:click="{{ $action }}" variant="primary"
    class="sm:col-span-2 w-full">Buscar</flux:button>
<div class="sm:col-span-6 font-medium">
    <span>Parámetros de visualización</span>
    <flux:separator />
</div>

<div wire:key="historico-{{ $model }}-checkboxes" class="sm:col-span-6 grid grid-cols-2">
    <div>
        <flux:checkbox wire:model.live="{{ $model }}.rango_fecha_activo" label="Activar rango de fechas" />
    </div>
    <flux:checkbox wire:model.live="{{ $model }}.incluir_mov_inventarios"
        label="Incluir movimientos de inventarios" />
</div>

<div wire:key="historico-{{ $model }}-inicio" class="sm:col-span-3 flex flex-col gap-4">
    <flux:input wire:model="{{ $model }}.fecha_inicio" type="date" size="sm" label="Fecha de incio" />
</div>
<div wire:key="historico-{{ $model }}-final" class="sm:col-span-3 flex flex-col gap-4">
    <flux:input wire:model="{{ $model }}.fecha_final" type="date" size="sm" label="Fecha final" />
</div>
