<flux:modal wire:model.self="showComponents" variant="flyout" class="w-96 sm:w-144" name="producto-componentes"
    wire:close="resetModal()">
    <div class="space-y-6">
        <div>
            <flux:heading size="lg">Definir componentes</flux:heading>
            <flux:text class="mt-2">Busca un componente y agregalo a la lista.</flux:text>
        </div>

        <flux:modal.trigger name="buscar-producto-componentes">
            <flux:button id="button-search-compuesto" size="sm" class="w-full">
                Buscar componentes
            </flux:button>
        </flux:modal.trigger>

        <x-generic-table header="Componentes Seleccionados" overflowY="max-h-36 md:max-h-64" :headerValues="['Acción', 'Cantidad', 'Clave', 'Descripción']">
            @if ($productComponents !== [])
                @slot('body')
                    @foreach ($productComponents as $index => $productComponent)
                        <tr
                            wire:key="{{ $productComponent->idcompoundproduct ?? $productComponent['producto']['clave'] }}{{ $productComponent['producto']['clave'] }}-{{ $index }}">
                            <x-generic-table.cell>
                                <flux:tooltip content="Remover">
                                    <flux:button type="button"
                                        wire:click="removeProductComponent({{ $index }})"
                                        wire:confirm="¿Estás seguro de eliminar el componente {{$productComponent['producto']['clave']}}?"
                                        size="sm" square>
                                            <flux:icon.trash variant="solid" />
                                    </flux:button>
                                </flux:tooltip>
                            </x-generic-table.cell>
                            <x-generic-table.cell>
                                <flux:input size="sm" wire:model="productComponents.{{ $index }}.cantidad" />
                            </x-generic-table.cell>
                            <x-generic-table.cell>{{ $productComponent['producto']['clave'] }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $productComponent['producto']['descripcion'] }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            @endif
        </x-generic-table>
        <div>

        </div>
        <div class="flex">

            <flux:spacer />

            <flux:button wire:click="$set('showComponents', false)" type="button" variant="primary">Cerrar
            </flux:button>
        </div>
    </div>
</flux:modal>
