<flux:modal name="buscar-producto-componentes" class="w-screen sm:!max-w-[75vw] !max-w-[95vw] !p-2 sm:!p-6"
    wire:close="$set('selectedProductComponent', null);$set('search.componentes', '')">
    <div class="space-y-2 sm:space-y-6">
        <div>
            <flux:heading size="lg">Definir componentes</flux:heading>
            <flux:text class="mt-2">Selecciona el criterio e ingresa el valor para buscar un componente.</flux:text>
        </div>
        <div class="w-5/6 sm:w-1/2">
            <flux:radio.group wire:model.live.debounce.500ms="search.componente_criterio" label="Criterio" variant="segmented" size="sm">
                <flux:radio value="descripcion" label="Descripción" />
                <flux:radio value="clave" label="Clave" />
                <flux:radio value="codigodebarras" label="Código de barras" />
                <flux:radio value="auto" label="Automático" />
            </flux:radio.group>
        </div>
        <flux:input size="sm" wire:model.live.debounce.500ms="search.componentes" type="text"
            placeholder="Buscar..." />
        @if ($searchProductComponents !== [])
            <x-generic-table header="Componentes" overflowY="max-h-36 md:max-h-64" :headerValues="['Clave', 'Descripción', 'Precio Venta', 'Prod.compuesto']">
                @slot('body')
                    @foreach ($searchProductComponents as $searchProductComponent)
                        <tr wire:click="$set('selectedProductComponent', {{ $searchProductComponent }})"
                            class="hover:cursor-pointer {{ $selectedProductComponent && $selectedProductComponent['clave'] === $searchProductComponent->clave ? 'bg-gray-200 hover:bg-gray-200' : 'hover:bg-gray-100' }}"
                            wire:key="{{ rand() }}">
                            <x-generic-table.cell>{{ $searchProductComponent->clave }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $searchProductComponent->descripcion }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $searchProductComponent->precioventaconiva }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $searchProductComponent->esproductocompuesto ? 'SI' : 'NO' }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>



            <div class="overflow-x-auto">
                {{ $searchProductComponents->links() }}
            </div>
        @endif
        <div class="flex">

            <flux:spacer />

            <flux:button wire:click="saveSelectectedComponent" type="submit" variant="primary">Seleccionar
            </flux:button>
        </div>
    </div>
</flux:modal>
