<flux:modal name="unidad-medida" class="w-screen sm:!max-w-[75vw] !max-w-[95vw] !p-2 sm:!p-6" wire:close="resetModal()">
    <div class="space-y-2 sm:space-y-6">
        <div>
            <flux:heading size="lg">Buscar Unidades de medida</flux:heading>
            <flux:text class="mt-2">Ingresa la clave, nombre o descripción de la unidad de medida.</flux:text>
        </div>


        <flux:input size="sm" wire:model.live.debounce.500ms="search.unidades" type="text" placeholder="Buscar..." />
        @if ($unidades !== [])
            <x-generic-table header="Unidades de medida" overflowY="max-h-48 md:max-h-84" :headerValues="['Clave', 'Nombre', 'Descripción']">
                @slot('body')
                    @foreach ($unidades as $unidad)
                        <tr wire:click="$set('selectedUnidad', {{ $unidad }})"
                            class="hover:cursor-pointer {{ $selectedUnidad && $selectedUnidad['clave_unidad'] === $unidad->clave_unidad ? 'bg-gray-200' : '' }}"
                            wire:key="{{ rand() }}">
                            <x-generic-table.cell>{{ $unidad->clave_unidad }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $unidad->nombre }}</x-generic-table.cell>
                            <x-generic-table.cell>{{ $unidad->descripcion }}</x-generic-table.cell>
                        </tr>
                    @endforeach
                @endslot
            </x-generic-table>



            <div class="overflow-x-auto">
                {{ $unidades->links() }}
            </div>
        @endif
        <div class="flex">

            <flux:spacer />

            <flux:button wire:click="saveUnidad" type="submit" variant="primary">Seleccionar</flux:button>
        </div>
    </div>
</flux:modal>
