<div class="sm:col-span-3">
    <div>
        <span class="font-medium">Impuestos traslados</span>
        <flux:separator />
    </div>
    <div class="grid grid-cols-1 sm:grid-cols-3 gap-8 items-end mt-4">
        <flux:checkbox wire:model.live="form.traslado_iva_exento" label="IVA EXENTO" />

        <flux:select size="sm" label="IVA %" wire:model.live="form.traslado_iva_tasa_cuota"
            :disabled="$form['traslado_iva_exento']">
            <flux:select.option value="" disabled selected>Seleccione una opción</flux:select.option>
            <flux:select.option value="0.000000">0</flux:select.option>
            <flux:select.option value="0.160000">16</flux:select.option>
        </flux:select>
        <flux:select size="sm" wire:model.live="form.traslado_ieps_tasa_cuota" label="IEPS %">
            <flux:select.option value="" disabled selected>Seleccione una opción</flux:select.option>
            <flux:select.option value="0.000000">0</flux:select.option>
            <flux:select.option value="0.300000">3</flux:select.option>
            <flux:select.option value="0.600000">6</flux:select.option>
            <flux:select.option value="0.700000">7</flux:select.option>
            <flux:select.option value="0.900000">9</flux:select.option>
            <flux:select.option value="0.250000">25</flux:select.option>
            <flux:select.option value="0.265000">26.5</flux:select.option>
            <flux:select.option value="0.300000">30</flux:select.option>
            <flux:select.option value="0.304000">30.4</flux:select.option>
            <flux:select.option value="0.500000">50</flux:select.option>
            <flux:select.option value="0.530000">53</flux:select.option>
            <flux:select.option value="1.600000">160</flux:select.option>
        </flux:select>
    </div>
</div>

<div class="sm:col-span-3">
    <div>
        <span class="font-medium">Impuestos retención</span>
        <flux:separator />
    </div>
    <div class="grid grid-cols-1 sm:grid-cols-2 gap-8 items-end mt-4">
        <x-input-label type="number" wire:model="form.retencion_iva_tasa_cuota" id="retencion_iva_tasa_cuota"
            label="IVA %(*)" />
        <x-input-label type="number" wire:model="form.retencion_isr_tasa_cuota" id="retencion_iva_tasa_cuota"
            label="ISR %(*)" />
    </div>
</div>

<div class="sm:col-span-3">
    <span class="font-medium">Compras y existencia mínima</span>
    <flux:separator />

    <div class="grid grid-cols-1 sm:grid-cols-2 gap-8 mt-8">
        <div class="sm:col-span-2">
            <flux:input type="date" wire:model="form.fechaultimacompra" max="2999-12-31" label="Fecha última compra"
                size="sm" />
        </div>
        <x-input-label type="text" id="precioultimacompra" wire:model.live.debounce.500ms="form.precioultimacompra"
            label="P.U.C. Sin impuestos(*)" error="form.precioultimacompra" />
        <x-input-label readonly variant="ghost" id="ultimacompra_ieps" wire:model="precios.ultimacompra_ieps"
            label="P.U.C. IEPS" />
        <x-input-label readonly variant="ghost" id="ultimacompra_iva" wire:model="precios.ultimacompra_iva"
            label="P.U.C. IVA" />
        <x-input-label class="!bg-yellow-100" id="ultimacompra_con_imp"
            wire:model.live.debounce.500ms="precios.ultimacompra_con_imp" label="P.U.C. Con impuestos" />

        <div class="sm:col-span-2">
            <flux:checkbox wire:model.live="cambiarCostosPromedio" label="Cambiar costos promedio" />
        </div>

        <div>
            <x-input-label :readonly="!$cambiarCostosPromedio" wire:model.live.debounce.500ms="form.costo_promedio_antesiva"
                variant="{{ $cambiarCostosPromedio ? 'default' : 'ghost' }}" id="costo_promedio_antesiva"
                label="Costo promedio (sin impuesto)" />
        </div>
        <x-input-label readonly variant="ghost" wire:model="precios.costo_promedio_ieps" id="costo_promedio_antesiva"
            label="Costo promedio (IEPS)" />
        <x-input-label readonly variant="ghost" wire:model="form.costo_promedio_iva" id="costo_promedio_iva"
            label="Costo promedio (IVA)" />
        <x-input-label readonly variant="ghost" wire:model="form.costo_promedio_despuesiva"
            id="costo_promedio_despuesiva" label="Costo promedio (con impuesto)" />

    </div>
</div>

<div class="sm:col-span-3">
    <span class="font-medium">Información ventas</span>
    <flux:separator />

    <div class="grid grid-cols-1 sm:grid-cols-2 gap-8 mt-8">
        <x-input-label readonly variant="ghost" type wire:model="form.porcentajeutilidad" id="porcentajeutilidad"
            label="% Utilidad (Precio última compra)" />
        <x-input-label readonly variant="ghost" wire:model="precios.utilidad_costo_promedio"
            id="utilidad_costo_promedio" label="% Utilidad (Costo promedio)" />
        <x-input-label wire:model.live.debounce.500ms="form.precioventaantesiva" id="precioventaantesiva"
            label="P.V sin impuesto(*)" error="form.precioventaantesiva" />
        <x-input-label readonly variant="ghost" wire:model="precios.venta_ieps_traslado" id="porcentajeutilidad"
            label="IEPS Traslado" />
        <x-input-label readonly variant="ghost" wire:model="precios.venta_iva_traslado" id="precio_venta_iva"
            label="IVA Traslado" />
        <x-input-label class="!bg-yellow-100" wire:model.live.debounce.500ms="form.precioventaconiva"
            id="precioventaconiva" label="P.V. Con impuesto" />
    </div>
</div>

<div class="sm:col-span-6">
    <span class="font-medium">Información de comisiones por ventas</span>
    <flux:separator />

    <div class="grid grid-cols-1 sm:grid-cols-3 gap-8 mt-8">
        <x-input-label wire:model="form.comision1x100" type="number" id="comision1x100"
            label="% para precio Normal" />
        <x-input-label wire:model="form.comision2x100" type="number" id="comision2x100"
            label="% para precio Medio Mayoreo" />
        <x-input-label wire:model="form.comision3x100" type="number" id="comision3x100"
            label="% para precio Mayoreo" />
    </div>
</div>
<flux:spacer></flux:spacer>
