<div class="w-full">
    <form wire:submit.prevet="save" method="post" class="flex flex-col">
        <x-sticky-scroll-box class="space-y-8">
            @slot('header')
            <div class="flex items-center justify-between w-full">
                <div class="flex border-b border-gray-200">
                    <button type="button" wire:click="$set('activeTab', 'general')"
                        class="px-4 py-2 text-sm font-medium text-gray-700 border-b-2 focus:outline-none {{ $activeTab === 'general' ? 'border-indigo-500 text-indigo-600' : 'border-transparent hover:text-gray-800 hover:border-gray-300' }}">
                        Información General
                    </button>
                    <button type="button" wire:click="$set('activeTab', 'permisos')"
                        class="px-4 py-2 text-sm font-medium text-gray-700 border-b-2 focus:outline-none {{ $activeTab === 'permisos' ? 'border-indigo-500 text-indigo-600' : 'border-transparent hover:text-gray-800 hover:border-gray-300' }}">
                        Permisos
                    </button>
                </div>
                <div class="transition-all flex items-center justify-between">
                    <flux:button variant="subtle" icon="chevron-left" x-on:click="history.back();" >Regresar</flux:button>
                    <div class="flex items-center justify-end gap-x-4">
                        <flux:button variant="ghost" wire:click="clear">
                            Limpiar
                        </flux:button>
        
                        <x-button-primary  >Guardar</x-button-primary>
                    </div>
                </div>
            </div>
            @endslot
            <div class=" grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-6 p-4">
                <!-- Información General -->
                @if ($activeTab === 'general')
                    <div class="grid grid-cols-1 gap-x-4 gap-y-4 sm:grid-cols-6">
                        <div class="sm:col-span-3">
                            <x-input-label id="nombre" wire:model="nombre" label="Nombre (*)" placeholder="Nombre" error="nombre" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="usuario" wire:model="usuario" label="Cuenta (*)" placeholder="Cuenta" error="usuario" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="pasword" wire:model="pasword" label="Contraseña" placeholder="Contraseña" error="pasword" />
                        </div>
                        <div class="sm:col-span-3">
                            <x-input-label id="confirmpasword" wire:model="confirmpasword" label="Confirmar Contraseña" placeholder="Confirmar Contraseña" error="confirmpasword" />
                        </div>
                        <div class="sm:col-span-3 flex items-center">
                            <x-select id="perfil" wire:model="perfil" label="Perfil" placeholder="Selecciona un perfil" error="perfil"         :options="$perfiles"/>
                        </div>
                        <div class="sm:col-span-3 flex items-center">
                            <x-select id="sucursal" wire:model="sucursal" label="Sucursal" placeholder="Selecciona una sucursal" error="sucursal"         :options="$sucursales"/>
                        </div>
                    </div>
                @endif

                <!-- Permisos -->
                @if ($activeTab === 'permisos')
                    <div class="space-y-8">
                        {{-- Administración --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Administración</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                            @foreach ($permisos[1] as $idx => $opcion)
                                <label class="inline-flex items-center">
                                    <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                    <span class="ml-2">
                                        {{ $opcion['nombre']}}
                                    </span>
                                </label>
                            @endforeach
                            </div>
                        </div>
                
                        {{-- Ventas --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Ventas</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[2] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                
                        {{-- CxC --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Cuentas por Cobrar</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[3] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                
                        {{-- Compras --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Compras</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[4] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                
                        {{-- Inventarios --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Inventarios</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[5] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- CxP--}}

                        <div>
                            <h3 class="text-lg font-semibold mb-2">Inventarios</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[6] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Catálogos --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Catálogos</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[7] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Reportes --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Reportes</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                                @foreach ($permisos[8] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Herramientas --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Herramientas</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4">
                                @foreach ($permisos[9] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Empeños --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Empeños</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[10] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Reparaciones --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Reparaciones</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[11] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Apartados --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Apartados</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[12] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Encargos --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Encargos</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[13] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>


                        {{-- Servicios --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Servicios</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[14] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Taller Servicios --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Taller Servicios</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[15] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        
                        {{-- Recibos de Nómina --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Recibos de Nómina</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[16] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>

                        {{-- Producción --}}
                        <div>
                            <h3 class="text-lg font-semibold mb-2">Producción</h3>
                            <div class="grid grid-cols-1 sm:grid-cols-4 gap-4">
                                @foreach ($permisos[17] as $idx => $opcion)
                                    <label class="inline-flex items-center">
                                        <input type="checkbox" wire:model="permisos.1.{{ $idx }}.permitir" class="form-checkbox">
                                        <span class="ml-2">
                                            {{ $opcion['nombre']}}
                                        </span>
                                    </label>
                                @endforeach
                            </div>
                        </div>
                    </div>
                @endif
            </div>
        </x-sticky-scroll-box>
    </form>
    <x-create-alert :title="$alert_title"  :text="$alert_text" />
</div>
