<div class="w-full px-4 py-4 space-y-4" x-data>
    <h1 class="text-xl font-semibold">Cambiar precios</h1>

    <!-- Datos generales -->
    <div class="bg-white rounded border">
        <div class=" text-black px-4 py-2 rounded-t">Datos generales de los productos a impactar</div>
        <div class="p-4 grid grid-cols-1 md:grid-cols-4 gap-4 text-sm">
            <div>
                <label for="filtroFamilia" class="block font-medium">Familia:</label>
                <select id="filtroFamilia" class="w-full border rounded p-2" wire:model.live.number="familiaId">
                    <option value="">Todas las familias</option>
                    @foreach ($familias ?? [] as $f)
                        <option value="{{ $f->id }}">{{ $f->nombre ?? ($f->descripcion ?? ($f->NOMBRE ?? 'Familia ' . $f->id)) }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="filtroMarca" class="block font-medium">Marca:</label>
                <select id="filtroMarca" class="w-full border rounded p-2" wire:model.live.number="marcaId">
                    <option value="">Todas las marcas</option>
                    @foreach ($marcas ?? [] as $m)
                        <option value="{{ $m->id }}">{{ $m->nombre ?? ($m->descripcion ?? ($m->NOMBRE ?? 'Marca ' . $m->id)) }}</option>
                    @endforeach
                </select>
            </div>
            <div class="md:col-span-2 flex items-center gap-6">
                <label class="inline-flex items-center gap-2">
                    <input type="checkbox" class="rounded border" wire:model.live="incluirInactivos" />
                    <span>Considerar productos inactivos</span>
                </label>
            </div>
            <p class="md:col-span-4 text-gray-600">Si hace clic en el botón <strong>Mostrar productos</strong>, podrá marcar los productos que se omitirán o se contemplarán al momento de aplicar los precios.</p>
        </div>
    </div>

    <!-- Datos de los precios a impactar -->
    <div class="bg-white rounded border">
        <div class=" text-black px-4 py-2 rounded-t">Datos de los precios a impactar</div>
        <div class="p-4 grid grid-cols-1 md:grid-cols-4 gap-4 text-sm">
            <div>
                <label for="aplicarPor" class="block font-medium">Aplicar por:</label>
                <select id="aplicarPor" class="w-full border rounded p-2" wire:model.live="aplicarPor">
                    <option value="porcentaje">Porcentaje</option>
                    <option value="monto">Monto</option>
                </select>
            </div>
            <div>
                <label for="cantidadImpacto" class="block font-medium">Cantidad:</label>
                <input id="cantidadImpacto" type="number" step="0.01" class="w-full border rounded p-2" wire:model.live.number="cantidad" />
            </div>
            <div>
                <label for="modoSeleccion" class="block font-medium">Los productos seleccionados son:</label>
                <select id="modoSeleccion" class="w-full border rounded p-2" wire:model.live="modoSeleccion">
                    <option value="contemplados">Contemplados</option>
                    <option value="omitidos">Omitidos</option>
                </select>
            </div>
            <div class="flex items-end">
                <button type="button" class="bg-emerald-600 hover:bg-emerald-700 text-white px-4 py-2 rounded" wire:click="aplicarPrecios">Aplicar precios</button>
            </div>
        </div>
    </div>

    <!-- Listado -->
    @if ($mostrarProductos)
        <div class="bg-white rounded border">
            <div class="p-4 text-sm">
                <div class="flex items-center justify-between mb-3">
                    <div>
                        <label class="inline-flex items-center gap-2">
                            <input type="checkbox" class="rounded border" wire:click="toggleSeleccionTodos">
                    
                            <span>Productos encontrados: <strong>{{ $totalEncontrados }}</strong></span>
                        </label>
                    </div>
                    <div>
                        <label class="inline-flex items-center gap-2">
                            <span class="text-gray-600">Filas:</span>
                            <input type="number" min="5" class="w-20 border rounded p-1" wire:model.live.number="filas">
                        </label>
                    </div>
                </div>

                <table class="w-full text-sm">
                    <thead>
                        <tr class="text-left border-b">
                            <th class="w-10"></th>
                            <th>Descripción</th>
                            <th>Clave</th>
                            <th>Código barras</th>
                            <th>Familia</th>
                            <th>Marca</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($productos as $p)
                            <tr class="border-b hover:bg-gray-50">
                                <td class="text-center">
                                    <input type="checkbox" class="rounded border" value="{{ $p->id }}" wire:model="seleccion">
                                </td>
                                <td>{{ $p->descripcion }}</td>
                                <td>{{ $p->clave }}</td>
                                <td>{{ $p->codigo_barras }}</td>
                                <td>{{ $p->familia_nombre ?? 'SIN FAMILIA' }}</td>
                                <td>{{ $p->marca_nombre ?? 'SINMARCA' }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-6 text-gray-500">Sin resultados</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>

                <div class="mt-3">
                    {{ $productos->links() }}
                </div>
            </div>
        </div>
    @endif

    @if (session()->has('message'))
        <div class="mt-3 text-sm px-3 py-2 rounded bg-emerald-100 text-emerald-800">{{ session('message') }}</div>
    @endif
    @if (session()->has('error'))
        <div class="mt-3 text-sm px-3 py-2 rounded bg-rose-100 text-rose-800">{{ session('error') }}</div>
    @endif

    <div>
        <script>
            document.addEventListener('livewire:init', function() {
                window.addEventListener('success-alert', (event) => {
                    Swal.fire({
                        title: event.detail[0]?.title || '¡Éxito!',
                        text: event.detail[0]?.text || 'La operación se completó correctamente.',
                        icon: 'success',
                        confirmButtonText: 'Aceptar'
                    });
                });

                window.addEventListener('error-alert', (event) => {
                    Swal.fire({
                        title: event.detail[0]?.title || '¡Error!',
                        text: event.detail[0]?.text || 'La operación no se pudo completar.',
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                });
            });
        </script>
    </div>
</div>
