<div class="container-fluid" x-data>
	<h1 class="h4 mb-3">Establecer precios y costos</h1>

	{{-- Filtros --}}
	<div class="card mb-3">
		<div class="card-body">
			<div class="row g-3">
				<div class="col-6 col-md-3 col-xl-2">
					<label for="fechaInicialVentas" class="form-label">Fecha inicial ventas</label>
					<input id="fechaInicialVentas" type="date" class="form-control form-control-sm" wire:model.lazy="fechaInicialVentas">
				</div>
				<div class="col-6 col-md-3 col-xl-2">
					<label for="fechaFinalVentas" class="form-label">Fecha final ventas</label>
					<input id="fechaFinalVentas" type="date" class="form-control form-control-sm" wire:model.lazy="fechaFinalVentas">
				</div>
				<div class="col-12 col-md-3 col-xl-2">
					<label for="sucursalId" class="form-label">Sucursal</label>
					<select id="sucursalId" class="form-select form-select-sm" wire:model="sucursalId">
						<option value="">Cualquier sucursal</option>
						@foreach($sucursales ?? [] as $s)
							<option value="{{ $s->id }}">{{ $s->nombre ?? $s->descripcion ?? $s->razon_social ?? 'Sucursal '.$s->id }}</option>
						@endforeach
					</select>
				</div>
				<div class="col-6 col-md-3 col-xl-2">
					<label for="marcaId" class="form-label">Marca</label>
					<select id="marcaId" class="form-select form-select-sm" wire:model="marcaId">
						<option value="">SINMARCA / Todas</option>
						@foreach($marcas ?? [] as $m)
							<option value="{{ $m->id }}">{{ $m->nombre ?? $m->descripcion ?? $m->NOMBRE ?? 'Marca '.$m->id }}</option>
						@endforeach
					</select>
				</div>
				<div class="col-6 col-md-3 col-xl-2">
					<label for="familiaId" class="form-label">Familia</label>
					<select id="familiaId" class="form-select form-select-sm" wire:model="familiaId">
						<option value="">Todas las familias</option>
						@foreach($familias ?? [] as $f)
							<option value="{{ $f->id }}">{{ $f->nombre ?? $f->descripcion ?? $f->NOMBRE ?? 'Familia '.$f->id }}</option>
						@endforeach
					</select>
				</div>
				<div class="col-6 col-md-3 col-xl-1">
					<label for="filas" class="form-label">Filas</label>
					<input id="filas" type="number" min="1" class="form-control form-control-sm" wire:model.lazy="filas" placeholder="10">
				</div>
				<div class="col-6 col-md-3 col-xl-1">
					<label for="existenciaFiltro" class="form-label">Existencias</label>
					<select id="existenciaFiltro" class="form-select form-select-sm" wire:model="existenciaFiltro">
						@foreach(($existenciasOptions ?? ['Todos'=>'Todos']) as $val => $txt)
							<option value="{{ $val }}">{{ $txt }}</option>
						@endforeach
					</select>
				</div>
				<div class="col-12 col-md-3 col-xl-2 d-flex align-items-end">
					<button wire:click="consultar" class="btn btn-sm btn-primary w-100">Consulta</button>
				</div>
				<div class="col-12">
					<div class="d-flex flex-wrap gap-3 small">
						<div class="form-check">
							<input id="filtrarSinFechas" class="form-check-input" type="checkbox" wire:model="filtrarSinFechas">
							<label for="filtrarSinFechas" class="form-check-label">Filtrar sin considerar fechas</label>
						</div>
						<div class="form-check">
							<input id="soloVendidos" class="form-check-input" type="checkbox" wire:model="soloVendidos">
							<label for="soloVendidos" class="form-check-label">Mostrar solo productos vendidos</label>
						</div>
						<div class="form-check">
							<input id="incluirInactivos" class="form-check-input" type="checkbox" wire:model="incluirInactivos">
							<label for="incluirInactivos" class="form-check-label">Considerar productos inactivos</label>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="d-flex flex-wrap justify-content-between align-items-center mb-2 gap-3">
		<div class="small fw-semibold">Productos totales: <span class="fw-bold">{{ $productos->total() ?? ($productos->count() ?? 0) }}</span></div>
		<div class="d-flex flex-wrap gap-2">
			<button wire:click="cambiarFamiliaSeleccionados" class="btn btn-sm btn-warning text-white">Cambiar familia</button>
			<button wire:click="cambiarMarcaSeleccionados" class="btn btn-sm btn-warning text-white">Cambiar marca</button>
			<button wire:click="restaurarTodos" class="btn btn-sm btn-warning text-white">Restaurar todos</button>
			<button wire:click="guardarCambios" class="btn btn-sm btn-success fw-semibold">Guardar cambios</button>
		</div>
	</div>

	<div class="d-flex flex-wrap gap-4 small mb-2">
		<div class="form-check">
			<input id="selectAll" type="checkbox" class="form-check-input" wire:click="toggleSeleccionTodos">
			<label for="selectAll" class="form-check-label">Seleccionar todos</label>
		</div>
		<div class="form-check">
			<input id="activarTodos" type="checkbox" class="form-check-input" wire:click="toggleActivoSeleccionados">
			<label for="activarTodos" class="form-check-label">Activar/Desactivar todos</label>
		</div>
	</div>

	<div class="card position-relative">
		<div class="table-responsive">
			<table class="table table-sm table-hover align-middle mb-0">
				<thead class="table-light">
					<tr class="small">
						<th class="text-center" style="width:35px">#</th>
						<th>Descripción</th>
						<th style="width:85px">Clave</th>
						<th style="width:140px">Código barras</th>
						<th style="width:110px">Stock mínimo</th>
						<th style="width:110px">Costo compra</th>
						<th style="width:110px">Precio venta</th>
						<th style="width:90px" class="text-end">Existencia</th>
						<th style="width:80px" class="text-end">Ventas</th>
						<th>Familia</th>
						<th>Marca</th>
						<th style="width:70px" class="text-center">Activo</th>
						<th style="width:30px"></th>
					</tr>
				</thead>
				<tbody>
				@forelse($productos ?? [] as $p)
					@php $pid = $p->id; @endphp
					<tr wire:key="prod-{{$pid}}" @class(['table-warning'=>($edits[$pid]['_dirty'] ?? false)])>
						<td class="text-center">
							<input type="checkbox" value="{{$pid}}" wire:model="seleccion">
						</td>
						<td class="small">{{ $p->descripcion ?? $p->DESCRIPCION ?? '—' }}</td>
						<td>
							<input type="text" wire:model.lazy="edits.{{$pid}}.clave" value="{{ $p->clave }}" class="form-control form-control-sm">
						</td>
						<td>
							<input type="text" wire:model.lazy="edits.{{$pid}}.codigo_barras" value="{{ $p->codigo_barras }}" class="form-control form-control-sm">
						</td>
						<td>
							<input type="number" step="0.001" wire:model.lazy="edits.{{$pid}}.stock_minimo" value="{{ $p->stock_minimo }}" class="form-control form-control-sm text-end">
						</td>
						<td>
							<input type="number" step="0.01" wire:model.lazy="edits.{{$pid}}.costo_compra" value="{{ $p->costo_compra }}" class="form-control form-control-sm text-end">
						</td>
						<td>
							<input type="number" step="0.01" wire:model.lazy="edits.{{$pid}}.precio_venta" value="{{ $p->precio_venta }}" class="form-control form-control-sm text-end">
						</td>
						<td class="text-end small">{{ number_format($p->existencia ?? 0,3) }}</td>
						<td class="text-end small">{{ number_format($p->ventas ?? 0,3) }}</td>
						<td class="small">{{ $p->familia_nombre ?? $p->familia ?? '—' }}</td>
						<td class="small">{{ $p->marca_nombre ?? $p->marca ?? 'SINMARCA' }}</td>
						<td class="text-center">
							<input type="checkbox" wire:model="edits.{{$pid}}.activo" @checked($p->activo)>
						</td>
						<td class="text-center">
							@if(($edits[$pid]['_dirty'] ?? false))
								<span class="badge bg-warning text-dark" title="Modificado">M</span>
							@endif
						</td>
					</tr>
				@empty
					<tr>
						<td colspan="13" class="text-center py-3 small text-muted">Sin resultados</td>
					</tr>
				@endforelse
				</tbody>
			</table>
		</div>

		@if(method_exists($productos,'links'))
			<div class="card-footer py-2">{{ $productos->links() }}</div>
		@endif

		<div wire:loading.flex class="position-absolute top-0 start-0 w-100 h-100 bg-white bg-opacity-75 d-flex justify-content-center align-items-center">
			<div class="d-flex align-items-center gap-2 text-primary small">
				<div class="spinner-border spinner-border-sm" aria-hidden="true"></div>
				<output>Cargando...</output>
			</div>
		</div>
	</div>

	@if (session()->has('message'))
		<div class="alert alert-success mt-3 py-2 px-3 small mb-0">{{ session('message') }}</div>
	@endif
	@if (session()->has('error'))
		<div class="alert alert-danger mt-3 py-2 px-3 small mb-0">{{ session('error') }}</div>
	@endif
</div>

