<div>
    <flux:heading class="mt-2" size="xl">Datos del producto a inventariar</flux:heading>
    <flux:separator></flux:separator>
</div>

<div class="grid gap-8 grid-cols-2 md:grid-cols-12">
    <flux:field id="{{ rand() }}" class="sm:col-span-3">
        <flux:label>Producto</flux:label>
        <flux:tooltip toggleable>
            <flux:input.group>
                <flux:input value="{{ $selectedProducto->nombrecorto ?? '' }}" readonly size="sm"
                    placeholder="Busca un producto" />
                <flux:modal.trigger name="{{ isset($selectedSucursal) ? 'producto-modal' : '' }}">
                    <flux:button size="sm" icon="magnifying-glass" />
                </flux:modal.trigger>
            </flux:input.group>
            @if (!isset($selectedSucursal))
                <flux:tooltip.content class="max-w-[20rem] space-y-2">
                    <p>
                        Es necesario seleccionar una sucursal antes de agregar productos.
                    </p>
                </flux:tooltip.content>
            @endif
        </flux:tooltip>
    </flux:field>

    <flux:field class="md:col-span-2">
        <flux:label>Existencia</flux:label>
        <flux:input variant="filled" readonly value="{{ $selectedProducto->existencia ?? '' }}" size="sm" />
    </flux:field>

    <flux:field class="md:col-span-2">
        <flux:label>Cantidad</flux:label>
        <flux:input :disabled="!isset($selectedProducto)" wire:model.live.debounce.250ms="partidaForm.cantidad"
            mask="9999" size="sm" />
    </flux:field>

    <flux:field class="md:col-span-2">
        <flux:label>Precio Unit.</flux:label>
        <flux:input variant="filled" readonly value="{{ $selectedProducto->precioultimacompra ?? '' }}"
            size="sm" />
    </flux:field>

    <flux:field class="md:col-span-3">
        <flux:label>Importe costo</flux:label>
        <flux:input variant="filled" readonly value="{{ $partidaForm['importe'] ?? '' }}" size="sm" />
    </flux:field>

    <flux:field class="md:col-span-2">
        <flux:label>Clave</flux:label>
        <flux:input variant="filled" readonly value="{{ $selectedProducto->clave ?? '' }}" size="sm" />
    </flux:field>

    <flux:field class="col-span-2 md:col-span-4">
        <flux:label>Descripción</flux:label>
        <flux:input variant="filled" readonly value="{{ $selectedProducto->descripcion ?? '' }}" size="sm" />
    </flux:field>

    <flux:field class="md:col-span-3">
        <flux:label>Fecha de caducidad</flux:label>
        <flux:input variant="filled" readonly value="{{ $partidaForm['fecha_caducidad'] ?? '' }}" size="sm" />
    </flux:field>

    <flux:field class="md:col-span-3">
        <flux:label>Lote origen</flux:label>
        <flux:input wire:model="partidaForm.lote" size="sm" />
    </flux:field>

    <flux:field class="col-span-2 md:col-span-6">
        <flux:label>Justificación</flux:label>
        <flux:textarea rows="auto" resize="none" wire:model="partidaForm.justificacion" size="sm" />
    </flux:field>

    <flux:field class="col-span-2 md:col-span-3">
        <flux:label>
            Imagen
        </flux:label>
        @php
            $isValidImage = isset($selectedProducto->imagen) && $selectedProducto->imagen !== '';
        @endphp
        @if ($isValidImage)
            <img src="{{ route('private.image', ['path' => $selectedProducto->imagen]) }}"
                alt="{{ $selectedProducto->nombrecorto }}" class="h-[9.8em]" />
        @else
            <img src="{{ asset('imagenes/default_producto.png') }}" alt="default_producto" class="h-[9.8em] w-full" />
        @endif
    </flux:field>

    <flux:field class="col-span-2 md:col-span-3">
        <flux:label>
            Acciones
        </flux:label>
        <div class="flex flex-col gap-2">
            <flux:button type="button" wire:click="addPartida" class="w-full" variant="primary" color="green">
                Agregar
            </flux:button>
            <flux:button type="button" variant="danger" class="w-full" x:bind:disabled="selectedPartidaIndex === null"
                @click="$wire.removePartida(selectedPartidaIndex).then(() => { selectedPartidaIndex = null })">
                Remover
            </flux:button>
        </div>
    </flux:field>
</div>
