<div class="p-4">
    <div class="flex items-center justify-between mb-4">
        <flux:heading size="xl">Reporte Concentrado - Cortes de Caja</flux:heading>
        <flux:button wire:click="volver" variant="ghost" icon="arrow-left">
            Volver
        </flux:button>
    </div>

    {{-- Información de filtros aplicados --}}
    <div class="bg-blue-50 rounded-lg p-4 mb-4">
        <h3 class="font-semibold mb-2">Filtros aplicados:</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-2 text-sm">
            <div><span class="font-medium">Fecha inicio:</span> {{ \Carbon\Carbon::parse($fechaInicio)->format('d/m/Y') }}</div>
            <div><span class="font-medium">Fecha fin:</span> {{ \Carbon\Carbon::parse($fechaFin)->format('d/m/Y') }}</div>
            <div><span class="font-medium">Estado:</span> 
                @if($opcionTurnos == 0)
                    No Cerrados
                @elseif($opcionTurnos == 1)
                    Cerrados
                @else
                    Ambos turnos
                @endif
            </div>
        </div>
    </div>

    {{-- Resumen general --}}
    <div class="bg-white rounded-lg shadow p-4 mb-4">
        <h3 class="text-lg font-semibold mb-3">Resumen General</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="bg-gray-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Total Turnos</div>
                <div class="text-xl font-bold text-gray-800">{{ $totalesGenerales['total_turnos'] ?? 0 }}</div>
            </div>
            <div class="bg-green-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Total Ingresos</div>
                <div class="text-xl font-bold text-green-700">${{ number_format($totalesGenerales['total_ingresos'] ?? 0, 2) }}</div>
            </div>
            <div class="bg-red-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Total Egresos</div>
                <div class="text-xl font-bold text-red-700">${{ number_format($totalesGenerales['total_egresos'] ?? 0, 2) }}</div>
            </div>
            <div class="bg-blue-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Total Cortes</div>
                <div class="text-xl font-bold text-blue-700">${{ number_format($totalesGenerales['total_cortes'] ?? 0, 2) }}</div>
            </div>
            <div class="bg-purple-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Turnos Cerrados</div>
                <div class="text-xl font-bold text-purple-700">{{ $totalesGenerales['turnos_cerrados'] ?? 0 }}</div>
            </div>
            <div class="bg-yellow-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Turnos Abiertos</div>
                <div class="text-xl font-bold text-yellow-700">{{ $totalesGenerales['turnos_abiertos'] ?? 0 }}</div>
            </div>
            <div class="bg-indigo-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Ingresos - Egresos</div>
                <div class="text-xl font-bold text-indigo-700">
                    ${{ number_format(($totalesGenerales['total_ingresos'] ?? 0) - ($totalesGenerales['total_egresos'] ?? 0), 2) }}
                </div>
            </div>
            <div class="bg-gray-50 rounded p-3">
                <div class="text-xs text-gray-600 mb-1">Diferencia</div>
                <div class="text-xl font-bold {{ ($totalesGenerales['diferencia'] ?? 0) >= 0 ? 'text-green-700' : 'text-red-700' }}">
                    ${{ number_format($totalesGenerales['diferencia'] ?? 0, 2) }}
                </div>
            </div>
        </div>
    </div>

    {{-- Tabla concentrada por sucursal --}}
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="px-4 py-3 bg-gray-50 border-b">
            <h3 class="text-lg font-semibold">Concentrado por Sucursal</h3>
        </div>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Sucursal</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Total Turnos</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Cerrados</th>
                        <th scope="col" class="px-4 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Abiertos</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total Ingresos</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total Egresos</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Ingresos - Egresos</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Total Cortes</th>
                        <th scope="col" class="px-4 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Diferencia</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($datosConcentrado as $dato)
                        @php
                            $ingresosMenosEgresos = $dato->total_ingresos - $dato->total_egresos;
                            $diferencia = $ingresosMenosEgresos - $dato->total_cortes;
                        @endphp
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3 text-sm font-medium text-gray-900">{{ $dato->sucursal ?? 'Sin sucursal' }}</td>
                            <td class="px-4 py-3 text-sm text-center">{{ $dato->total_turnos }}</td>
                            <td class="px-4 py-3 text-sm text-center">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-green-100 text-green-800">
                                    {{ $dato->turnos_cerrados }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-sm text-center">
                                <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                    {{ $dato->turnos_abiertos }}
                                </span>
                            </td>
                            <td class="px-4 py-3 text-sm text-right font-medium text-green-600">
                                ${{ number_format($dato->total_ingresos, 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right font-medium text-red-600">
                                ${{ number_format($dato->total_egresos, 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right font-medium text-indigo-600">
                                ${{ number_format($ingresosMenosEgresos, 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right font-medium text-blue-600">
                                ${{ number_format($dato->total_cortes, 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right font-bold {{ $diferencia >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                ${{ number_format($diferencia, 2) }}
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="9" class="px-4 py-8 text-center text-gray-500">
                                No se encontraron datos para el período seleccionado
                            </td>
                        </tr>
                    @endforelse
                </tbody>
                @if(count($datosConcentrado) > 0)
                    <tfoot class="bg-gray-100">
                        <tr class="font-bold">
                            <td class="px-4 py-3 text-sm">TOTALES</td>
                            <td class="px-4 py-3 text-sm text-center">{{ $totalesGenerales['total_turnos'] }}</td>
                            <td class="px-4 py-3 text-sm text-center">{{ $totalesGenerales['turnos_cerrados'] }}</td>
                            <td class="px-4 py-3 text-sm text-center">{{ $totalesGenerales['turnos_abiertos'] }}</td>
                            <td class="px-4 py-3 text-sm text-right text-green-600">
                                ${{ number_format($totalesGenerales['total_ingresos'], 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right text-red-600">
                                ${{ number_format($totalesGenerales['total_egresos'], 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right text-indigo-600">
                                ${{ number_format($totalesGenerales['total_ingresos'] - $totalesGenerales['total_egresos'], 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right text-blue-600">
                                ${{ number_format($totalesGenerales['total_cortes'], 2) }}
                            </td>
                            <td class="px-4 py-3 text-sm text-right {{ $totalesGenerales['diferencia'] >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                ${{ number_format($totalesGenerales['diferencia'], 2) }}
                            </td>
                        </tr>
                    </tfoot>
                @endif
            </table>
        </div>
    </div>
</div>
