<div class="p-4">
    <div class="mb-4">
        <flux:button icon="chevron-left" variant="subtle" wire:click="volver">
            Regresar
        </flux:button>
    </div>

    <flux:heading size="xl">Detalle de Corte de Caja</flux:heading>
    <flux:separator class="my-4"></flux:separator>

    @if($corte)
        {{-- Información General --}}
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <flux:heading size="lg">Información General</flux:heading>
            <flux:separator class="my-2"></flux:separator>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <flux:label>Sucursal</flux:label>
                    <flux:text>{{ $sucursal->razon_social ?? 'N/A' }}</flux:text>
                </div>
                <div>
                    <flux:label>Usuario</flux:label>
                    <flux:text>{{ $corte->usuario }}</flux:text>
                </div>
                <div>
                    <flux:label>Caja</flux:label>
                    <flux:text>{{ $corte->nombre_caja }}</flux:text>
                </div>
                <div>
                    <flux:label>ID Turno</flux:label>
                    <flux:text>{{ $corte->idturno }}</flux:text>
                </div>
                <div>
                    <flux:label>Fecha Apertura</flux:label>
                    <flux:text>{{ \Carbon\Carbon::parse($corte->fechaapertura)->format('d/m/Y H:i') }}</flux:text>
                </div>
                <div>
                    <flux:label>Fecha Cierre</flux:label>
                    <flux:text>{{ $corte->fechacierre ? \Carbon\Carbon::parse($corte->fechacierre)->format('d/m/Y H:i') : 'Turno Abierto' }}</flux:text>
                </div>
            </div>
        </div>

        {{-- Desglose de Efectivo y Formas de Pago --}}
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <flux:heading size="lg">Desglose de Efectivo y Formas de Pago</flux:heading>
            <flux:separator class="my-2"></flux:separator>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                {{-- Billetes --}}
                <div>
                    <flux:heading size="sm" class="mb-2">Billetes</flux:heading>
                    <div class="space-y-2">
                        <div class="flex justify-between">
                            <flux:text>$1000:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->billetes_mil ?? 0 }} = ${{ number_format(($corte->billetes_mil ?? 0) * 1000, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$500:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->billetes_quinientos ?? 0 }} = ${{ number_format(($corte->billetes_quinientos ?? 0) * 500, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$200:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->billetes_doscientos ?? 0 }} = ${{ number_format(($corte->billetes_doscientos ?? 0) * 200, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$100:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->billetes_cien ?? 0 }} = ${{ number_format(($corte->billetes_cien ?? 0) * 100, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$50:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->billetes_cincuenta ?? 0 }} = ${{ number_format(($corte->billetes_cincuenta ?? 0) * 50, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$20:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->billetes_veinte ?? 0 }} = ${{ number_format(($corte->billetes_veinte ?? 0) * 20, 2) }}</flux:text>
                        </div>
                        <flux:separator class="my-2"></flux:separator>
                        <div class="flex justify-between font-bold">
                            <flux:text>Total Billetes:</flux:text>
                            <flux:text>${{ number_format($corte->importetotalbilletes ?? 0, 2) }}</flux:text>
                        </div>
                    </div>
                </div>

                {{-- Monedas --}}
                <div>
                    <flux:heading size="sm" class="mb-2">Monedas</flux:heading>
                    <div class="space-y-2">
                        <div class="flex justify-between">
                            <flux:text>$20:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->monedas_veinte ?? 0 }} = ${{ number_format(($corte->monedas_veinte ?? 0) * 20, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$10:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->monedas_diez ?? 0 }} = ${{ number_format(($corte->monedas_diez ?? 0) * 10, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$5:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->monedas_cinco ?? 0 }} = ${{ number_format(($corte->monedas_cinco ?? 0) * 5, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$2:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->monedas_dos ?? 0 }} = ${{ number_format(($corte->monedas_dos ?? 0) * 2, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$1:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->monedas_uno ?? 0 }} = ${{ number_format(($corte->monedas_uno ?? 0) * 1, 2) }}</flux:text>
                        </div>
                        <div class="flex justify-between">
                            <flux:text>$0.50:</flux:text>
                            <flux:text class="font-semibold">{{ $corte->monedas_cincuenta_cent ?? 0 }} = ${{ number_format(($corte->monedas_cincuenta_cent ?? 0) * 0.50, 2) }}</flux:text>
                        </div>
                        <flux:separator class="my-2"></flux:separator>
                        <div class="flex justify-between font-bold">
                            <flux:text>Total Monedas:</flux:text>
                            <flux:text>${{ number_format($corte->importetotalmonedas ?? 0, 2) }}</flux:text>
                        </div>
                    </div>
                </div>
            </div>

            {{-- Otras Formas de Pago --}}
            <flux:separator class="my-4"></flux:separator>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                <div>
                    <flux:label>Tarjetas de Débito</flux:label>
                    <flux:text class="font-bold text-lg">${{ number_format($corte->importetarjetasdebito ?? 0, 2) }}</flux:text>
                </div>
                <div>
                    <flux:label>Tarjetas de Crédito</flux:label>
                    <flux:text class="font-bold text-lg">${{ number_format($corte->importetarjetascredito ?? 0, 2) }}</flux:text>
                </div>
                <div>
                    <flux:label>Transferencias</flux:label>
                    <flux:text class="font-bold text-lg">${{ number_format($corte->transferencia_electronica ?? 0, 2) }}</flux:text>
                </div>
                <div>
                    <flux:label>Vales Electrónicos</flux:label>
                    <flux:text class="font-bold text-lg">${{ number_format($corte->vales_electronicos ?? 0, 2) }}</flux:text>
                </div>
            </div>
        </div>

        {{-- Ingresos por Tipo de Pago --}}
        @if(count($ingresosPorTipoPago) > 0)
            <div class="bg-white rounded-lg shadow p-6 mb-6">
                <flux:heading size="lg">Ingresos por Tipo de Pago</flux:heading>
                <flux:separator class="my-2"></flux:separator>

                <x-generic-table header="" :headerValues="['Tipo de Pago', 'Importe']">
                    @slot('body')
                        @foreach($ingresosPorTipoPago as $ingreso)
                            <tr>
                                <x-generic-table.cell>{{ $ingreso->concepto }}</x-generic-table.cell>
                                <x-generic-table.cell class="text-right font-semibold">
                                    ${{ number_format($ingreso->importe, 2) }}
                                </x-generic-table.cell>
                            </tr>
                        @endforeach
                        <tr class="bg-gray-100 font-bold">
                            <x-generic-table.cell>TOTAL</x-generic-table.cell>
                            <x-generic-table.cell class="text-right">
                                ${{ number_format($totalPorTipoPago, 2) }}
                            </x-generic-table.cell>
                        </tr>
                    @endslot
                </x-generic-table>
            </div>
        @endif

        {{-- Ingresos --}}
        @if(count($ingresos) > 0)
            <div class="bg-white rounded-lg shadow p-6 mb-6">
                <flux:heading size="lg">Ingresos</flux:heading>
                <flux:separator class="my-2"></flux:separator>

                <x-generic-table header="" :headerValues="['Concepto', 'Importe']">
                    @slot('body')
                        @foreach($ingresos as $ingreso)
                            <tr>
                                <x-generic-table.cell>{{ $ingreso->concepto }}</x-generic-table.cell>
                                <x-generic-table.cell class="text-right font-semibold text-green-600">
                                    ${{ number_format($ingreso->importe, 2) }}
                                </x-generic-table.cell>
                            </tr>
                        @endforeach
                        <tr class="bg-green-100 font-bold">
                            <x-generic-table.cell>TOTAL INGRESOS</x-generic-table.cell>
                            <x-generic-table.cell class="text-right text-green-700">
                                ${{ number_format($totalIngresos, 2) }}
                            </x-generic-table.cell>
                        </tr>
                    @endslot
                </x-generic-table>
            </div>
        @endif

        {{-- Egresos --}}
        @if(count($egresos) > 0)
            <div class="bg-white rounded-lg shadow p-6 mb-6">
                <flux:heading size="lg">Egresos</flux:heading>
                <flux:separator class="my-2"></flux:separator>

                <x-generic-table header="" :headerValues="['Concepto', 'Importe']">
                    @slot('body')
                        @foreach($egresos as $egreso)
                            <tr>
                                <x-generic-table.cell>{{ $egreso->concepto }}</x-generic-table.cell>
                                <x-generic-table.cell class="text-right font-semibold text-red-600">
                                    ${{ number_format($egreso->importe, 2) }}
                                </x-generic-table.cell>
                            </tr>
                        @endforeach
                        <tr class="bg-red-100 font-bold">
                            <x-generic-table.cell>TOTAL EGRESOS</x-generic-table.cell>
                            <x-generic-table.cell class="text-right text-red-700">
                                ${{ number_format($totalEgresos, 2) }}
                            </x-generic-table.cell>
                        </tr>
                    @endslot
                </x-generic-table>
            </div>
        @endif

        {{-- Resumen Final --}}
        <div class="rounded-lg shadow p-6 mb-6 bg-gradient-to-r from-blue-50 to-blue-100">
            <flux:heading size="lg">Resumen Final</flux:heading>
            <flux:separator class="my-2"></flux:separator>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div class="bg-white p-4 rounded-lg">
                    <flux:label>Total Contado (Efectivo + Tarjetas + Otros)</flux:label>
                    <flux:text class="font-bold text-2xl text-blue-700">
                        ${{ number_format($corte->importetotalbilletes + $corte->importetotalmonedas + $corte->importetarjetasdebito + $corte->importetarjetascredito + ($corte->transferencia_electronica ?? 0) + ($corte->vales_electronicos ?? 0) + ($corte->cheques ?? 0), 2) }}
                    </flux:text>
                </div>

                <div class="bg-white p-4 rounded-lg">
                    <flux:label>Ingresos - Egresos (Del Sistema)</flux:label>
                    <flux:text class="font-bold text-2xl text-green-700">
                        ${{ number_format($totalIngresos - $totalEgresos, 2) }}
                    </flux:text>
                </div>

                <div class="bg-white p-4 rounded-lg md:col-span-2">
                    <flux:label>Diferencia (Contado - Sistema)</flux:label>
                    <flux:text class="font-bold text-3xl {{ $diferencia >= 0 ? 'text-green-600' : 'text-red-600' }}">
                        ${{ number_format($diferencia, 2) }}
                        @if($diferencia > 0)
                            <span class="text-sm">(Sobrante)</span>
                        @elseif($diferencia < 0)
                            <span class="text-sm">(Faltante)</span>
                        @else
                            <span class="text-sm">(Exacto)</span>
                        @endif
                    </flux:text>
                </div>
            </div>
        </div>

        {{-- Botones de acción --}}
        <div class="flex gap-2 justify-end">
            <flux:button wire:click="descargarPDF" icon="arrow-down-tray" variant="primary">
                Descargar PDF
            </flux:button>
            <flux:button wire:click="descargarExcel" icon="arrow-down-tray" variant="ghost">
                Descargar Excel
            </flux:button>
        </div>
    @else
        <div class="bg-white rounded-lg shadow p-6">
            <div class="text-center py-8 text-gray-500">
                No se encontró información del corte de caja
            </div>
        </div>
    @endif
</div>
