<div class="p-4">

    {{-- Filtros principales --}}
    <div class="bg-white rounded-lg shadow p-4 mb-4">
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-4">
            <flux:field>
                <flux:label>Fecha inicio:</flux:label>
                <flux:input wire:model.live="fechaInicio" type="date" size="sm" />
            </flux:field>

            <flux:field>
                <flux:label>Fecha fin:</flux:label>
                <flux:input wire:model.live="fechaFin" type="date" size="sm" />
            </flux:field>

            <flux:field>
                <flux:label>Sucursal:</flux:label>
                <flux:select wire:model.live="idSucursal" size="sm">
                    <flux:select.option value="">Todas las sucursales</flux:select.option>
                    @foreach ($sucursales as $sucursal)
                        <flux:select.option value="{{ $sucursal->idsucursal }}">
                            {{ $sucursal->razon_social }}
                        </flux:select.option>
                    @endforeach
                </flux:select>
            </flux:field>

            <flux:field>
                <flux:label>Usuarios</flux:label>
                <flux:select wire:model.live="idUsuario" size="sm">
                    <flux:select.option value="">Todos los usuarios</flux:select.option>
                    @foreach ($usuarios as $usuario)
                        <flux:select.option value="{{ $usuario->idusuario }}">
                            {{ $usuario->nombre }}
                        </flux:select.option>
                    @endforeach
                </flux:select>
            </flux:field>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-4 items-end">
            <flux:field>
                <flux:label>Turnos:</flux:label>
                <flux:input.group>
                    <flux:input 
                        wire:model.live.debounce.500ms="search" 
                        type="text" 
                        placeholder="Buscar..."
                        size="sm"
                    />
                    <flux:button 
                        wire:click="abrirModalTurnos" 
                        size="sm" 
                        icon="magnifying-glass" 
                        square 
                    />
                </flux:input.group>
            </flux:field>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Opción turnos:</label>
                <div class="flex gap-4">
                    <label class="inline-flex items-center">
                        <input type="radio" wire:model.live="opcionTurnos" value="2" class="form-radio text-indigo-600">
                        <span class="ml-2 text-sm">Ambos turnos</span>
                    </label>
                    <label class="inline-flex items-center">
                        <input type="radio" wire:model.live="opcionTurnos" value="1" class="form-radio text-indigo-600">
                        <span class="ml-2 text-sm">Cerrados</span>
                    </label>
                    <label class="inline-flex items-center">
                        <input type="radio" wire:model.live="opcionTurnos" value="0" class="form-radio text-indigo-600">
                        <span class="ml-2 text-sm">No Cerrados</span>
                    </label>
                </div>
            </div>

            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Opción:</label>
                <div class="flex gap-2">
                    <flux:button wire:click="consultar" variant="primary" size="sm" class="flex-1">Consulta</flux:button>
                    <flux:button wire:click="consultarConcentrado" variant="primary" size="sm" class="flex-1">Consultar concentrado</flux:button>
                    <flux:dropdown>
                        <flux:button size="sm" class="bg-green-600 hover:bg-green-700 text-white" icon-trailing="chevron-down">
                            Exportar
                        </flux:button>
                        <flux:menu>
                            <flux:menu.item wire:click="exportarExcel" icon="document-arrow-down">Excel</flux:menu.item>
                            <flux:menu.item wire:click="exportarPDF" icon="document-text">PDF</flux:menu.item>
                        </flux:menu>
                    </flux:dropdown>
                </div>
            </div>
        </div>
    </div>

    {{-- Sumatorias --}}
    <div class="bg-white rounded-lg shadow p-4 mb-4">
        <h3 class="text-lg font-semibold mb-3">Sumatorias:</h3>
        <div class="grid grid-cols-2 gap-4">
            <div class="space-y-2">
                <div class="flex justify-between border-b pb-2">
                    <span class="font-medium">Concepto</span>
                    <span class="font-medium">Importe</span>
                </div>
                <div class="flex justify-between">
                    <span>Ingresos</span>
                    <span class="font-semibold">${{ number_format($totales['total_ingresos'] ?? 0, 2) }}</span>
                </div>
                <div class="flex justify-between">
                    <span>Egresos</span>
                    <span class="font-semibold">${{ number_format($totales['total_egresos'] ?? 0, 2) }}</span>
                </div>
                <div class="flex justify-between">
                    <span>Ingresos - Egresos</span>
                    <span class="font-semibold">${{ number_format(($totales['total_ingresos'] ?? 0) - ($totales['total_egresos'] ?? 0), 2) }}</span>
                </div>
                <div class="flex justify-between">
                    <span>Cortes de caja empleados</span>
                    <span class="font-semibold">${{ number_format($totales['total_cortes'] ?? 0, 2) }}</span>
                </div>
                <div class="flex justify-between border-t pt-2">
                    <span class="font-bold">Cortes_Empleados - (Ingresos - Egresos)</span>
                    <span class="font-bold">${{ number_format($totales['diferencia'] ?? 0, 2) }}</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Tabla de cortes --}}
    <div class="bg-white rounded-lg shadow overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Turno</th>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fecha apertura</th>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Cerrado</th>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fecha cierre</th>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Hrs. trabajadas</th>
                        <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Ingresos</th>
                        <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Egresos</th>
                        <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Ingresos - Egresos</th>
                        <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Corte empleado</th>
                        <th scope="col" class="px-3 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Corte_Empleado - (Ingresos - Egresos)</th>
                        <th scope="col" class="px-3 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Usuario</th>
                        <th scope="col" class="px-3 py-3 text-center text-xs font-medium text-gray-500 uppercase tracking-wider">Inf.</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse ($cortes as $corte)
                        <tr wire:key="corte-{{ $corte->idturno }}-{{ $corte->idsucursal }}" class="hover:bg-gray-50">
                            <td class="px-3 py-3 whitespace-nowrap text-sm">{{ $corte->idturno }}</td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm">
                                {{ $corte->fechahora_apertura ? \Carbon\Carbon::parse($corte->fechahora_apertura)->format('d/m/Y H:i') : 'N/A' }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm">
                                {{ $corte->turno_cerrado ? 'Sí' : 'No' }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm">
                                {{ $corte->fechahora_cierre ? \Carbon\Carbon::parse($corte->fechahora_cierre)->format('d/m/Y H:i') : 'N/A' }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm">
                                @if($corte->fechahora_apertura && $corte->fechahora_cierre)
                                    {{ round(\Carbon\Carbon::parse($corte->fechahora_apertura)->diffInHours(\Carbon\Carbon::parse($corte->fechahora_cierre)), 2) }} hrs
                                @else
                                    N/A
                                @endif
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm text-right font-medium text-green-600">
                                ${{ number_format($corte->ingresos ?? 0, 2) }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm text-right font-medium text-red-600">
                                ${{ number_format($corte->egresos ?? 0, 2) }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm text-right font-medium">
                                ${{ number_format(($corte->ingresos ?? 0) - ($corte->egresos ?? 0), 2) }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm text-right font-medium">
                                ${{ number_format($corte->total_corte ?? 0, 2) }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm text-right font-medium {{ (($corte->total_corte ?? 0) - (($corte->ingresos ?? 0) - ($corte->egresos ?? 0))) >= 0 ? 'text-green-600' : 'text-red-600' }}">
                                ${{ number_format(($corte->total_corte ?? 0) - (($corte->ingresos ?? 0) - ($corte->egresos ?? 0)), 2) }}
                            </td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm">{{ $corte->usuario }}</td>
                            <td class="px-3 py-3 whitespace-nowrap text-sm text-center">
                                <flux:button 
                                    wire:click="verDetalle({{ $corte->idturno }}, {{ $corte->idsucursal }})" 
                                    size="sm"
                                    variant="ghost"
                                    icon="information-circle"
                                    square
                                />
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="12" class="px-3 py-8 text-center text-gray-500">
                                <div class="text-sm">Registros totales: 0</div>
                                <div class="text-xs mt-1">No se encontraron cortes de caja con los filtros seleccionados</div>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if(count($cortes) > 0)
            <div class="px-4 py-3 bg-gray-50 border-t">
                <div class="text-sm text-gray-700">
                    Registros totales: {{ $cortes->total() }}
                </div>
            </div>
        @endif
    </div>

    {{-- Paginación --}}
    @if(count($cortes) > 0)
        <div class="mt-4">
            {{ $cortes->links() }}
        </div>
    @endif

    {{-- Modal de filtro de turnos --}}
    <flux:modal name="filtro-turnos" :open="$mostrarModalTurnos" wire:model="mostrarModalTurnos">
        <form wire:submit.prevent="aplicarFiltroTurnosModal" class="space-y-6">
            <div>
                <flux:heading size="lg">Definir turnos a filtrar</flux:heading>
            </div>

            <flux:separator />

            <div class="space-y-4">
                {{-- No considerar turnos --}}
                <label class="flex items-start gap-3 cursor-pointer">
                    <input 
                        type="radio" 
                        wire:model.live="tipoFiltroTurnos" 
                        value="no_considerar"
                        class="mt-1 form-radio text-indigo-600"
                    />
                    <span class="text-base font-semibold">No considerar turnos</span>
                </label>

                {{-- Rango --}}
                <div class="space-y-3">
                    <label class="flex items-start gap-3 cursor-pointer">
                        <input 
                            type="radio" 
                            wire:model.live="tipoFiltroTurnos" 
                            value="rango"
                            class="mt-1 form-radio text-indigo-600"
                        />
                        <span class="text-base font-semibold">Rango</span>
                    </label>
                    
                    @if($tipoFiltroTurnos === 'rango')
                        <div class="ml-8 grid grid-cols-2 gap-4 items-center">
                            <div class="flex items-center gap-2">
                                <span class="text-sm">De</span>
                                <flux:input 
                                    wire:model="turnoDesde" 
                                    type="number"
                                    placeholder=""
                                    size="sm"
                                    class="flex-1"
                                />
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="text-sm">hasta</span>
                                <flux:input 
                                    wire:model="turnoHasta" 
                                    type="number"
                                    placeholder=""
                                    size="sm"
                                    class="flex-1"
                                />
                            </div>
                        </div>
                    @endif
                </div>

                {{-- Precisos --}}
                <div class="space-y-3">
                    <label class="flex items-start gap-3 cursor-pointer">
                        <input 
                            type="radio" 
                            wire:model.live="tipoFiltroTurnos" 
                            value="precisos"
                            class="mt-1 form-radio text-indigo-600"
                        />
                        <span class="text-base font-semibold">Precisos. Ejemplo: 23,45,67</span>
                    </label>
                    
                    @if($tipoFiltroTurnos === 'precisos')
                        <div class="ml-8">
                            <flux:input 
                                wire:model="turnosPrecisos" 
                                type="text"
                                placeholder="23,45,67"
                                size="sm"
                                class="w-full"
                            />
                        </div>
                    @endif
                </div>

                {{-- Considerar fechas --}}
                <label class="flex items-start gap-3 cursor-pointer">
                    <input 
                        type="checkbox" 
                        wire:model="considerarFechas"
                        class="mt-1 form-checkbox text-indigo-600"
                    />
                    <span class="text-base font-semibold">Considerar fechas</span>
                </label>
            </div>

            <flux:separator />

            <div class="flex justify-end">
                <flux:button type="submit" variant="primary" class="bg-green-600 hover:bg-green-700">
                    Aceptar
                </flux:button>
            </div>
        </form>
    </flux:modal>
</div>
