<div>
    {{-- Modal de Turnos --}}
    <flux:modal name="turnos-modal" wire:model="modalTurnosOpen" class="max-w-md">
        <div class="space-y-6 p-4">
            <div>
                <flux:heading size="lg">Seleccionar Turnos</flux:heading>

                {{-- Estado actual de la selección --}}
                @if ($usarTurnos)
                    <div
                        class="mt-3 p-3 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
                        <div class="flex items-start gap-2">
                            <flux:icon.information-circle
                                class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" />
                            <div>
                                <p class="text-sm font-medium text-blue-900 dark:text-blue-100">Filtro activo:</p>
                                <p class="text-sm text-blue-700 dark:text-blue-300">{{ $this->turnosLabel }}</p>
                            </div>
                        </div>
                    </div>
                @endif
            </div>

            <div class="space-y-4">
                <flux:radio.group wire:model.live="tipoSeleccionTurnos" label="Tipo de selección">
                    <flux:radio value="rango" label="Rango de turnos" />
                    <flux:radio value="individual" label="Turnos individuales" />
                    <flux:radio value="todos" label="Todos los turnos" />
                </flux:radio.group>

                @if ($tipoSeleccionTurnos === 'rango')
                    <div class="grid grid-cols-2 gap-4">
                        <flux:field>
                            <flux:label>Turno inicial</flux:label>
                            <flux:input wire:model="turnoInicial" type="number" placeholder="1" min="1" />
                            <flux:error name="turnoInicial" />
                        </flux:field>

                        <flux:field>
                            <flux:label>Turno final</flux:label>
                            <flux:input wire:model="turnoFinal" type="number" placeholder="100" min="1" />
                            <flux:error name="turnoFinal" />
                        </flux:field>
                    </div>

                    <flux:field>
                        <flux:checkbox wire:model="considerarFechas" label="Considerar también el rango de fechas" />
                    </flux:field>
                @elseif($tipoSeleccionTurnos === 'individual')
                    <flux:field>
                        <flux:label>Turnos (separados por coma)</flux:label>
                        <flux:input wire:model.live="turnosIndividuales" placeholder="Ej: 1, 5, 10, 15" x-data
                            x-on:input="$el.value = $el.value.replace(/[^0-9,\s]/g, '').replace(/,{2,}/g, ',')" />
                        <flux:description>Solo números y comas. Ej: 1,5,10,15</flux:description>
                        <flux:error name="turnosIndividuales" />
                    </flux:field>

                    <flux:field>
                        <flux:checkbox wire:model="considerarFechas" label="Considerar también el rango de fechas" />
                    </flux:field>
                @endif
            </div>
            <div class="flex gap-2">
                @if ($usarTurnos)
                    <flux:button variant="ghost" wire:click="limpiarTurnos">
                        Limpiar filtro
                    </flux:button>
                @endif
                <flux:spacer />
                <flux:button variant="ghost" wire:click="$set('modalTurnosOpen', false)">
                    Cancelar
                </flux:button>
                <flux:button variant="primary" wire:click="seleccionarTurnos">
                    Aplicar
                </flux:button>
            </div>
        </div>
    </flux:modal>

    {{-- Modal de Exportar --}}
    <x-export-modal
        title="Exportar reporte de ventas por familia de producto"
        description="Seleccione el formato en el que desea exportar el reporte generado."
        exportPdf="exportar('pdf')"
        exportExcel="exportar('excel')"
        wire:model="modalExportarOpen"
    />
</div>
