{{-- Filtros de búsqueda --}}
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-sm border border-gray-200 dark:border-gray-700 p-6 mb-6">
    <div class="flex items-center justify-between mb-4">
        <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Filtros de búsqueda</h3>
        
        <flux:button wire:click="$set('isOpenModalExportarReporte', true)" variant="primary"
                    class="bg-green-600 hover:bg-green-700 text-white">
                    Exportar
                </flux:button>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
        {{-- Búsqueda por texto --}}
        <flux:field>
            <flux:label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Buscar producto
            </flux:label>
            <flux:input wire:model.live.debounce.500ms="search" type="text"
                placeholder="Folio, clave, descripción..." size="sm" />
        </flux:field>

        {{-- Filtro de familia --}}
        <flux:field>
            <flux:label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Familia
            </flux:label>
            <flux:select wire:model.live="familia" size="sm">
                <option value="">Todas las familias</option>
                @foreach ($familias as $fam)
                    <option value="{{ $fam->idfamily }}">{{ $fam->nombrefamilia }}</option>
                @endforeach
            </flux:select>
        </flux:field>

        {{-- Tipo de búsqueda --}}
        <flux:field>
            <flux:label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Tipo de búsqueda
            </flux:label>
            <flux:select wire:model.live="tipoBusqueda" size="sm">
                <option value="">Todos los productos</option>
                <option value="productossobrantes">Productos sobrantes</option>
                <option value="stockminimo_igual_a_existencia">Stock = Existencia</option>
                <option value="stockminimo0_y_existencia0">Stock 0 y Existencia 0</option>
            </flux:select>
        </flux:field>

        {{-- Criterio de existencias --}}
        <flux:field>
            <flux:label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                Existencias
            </flux:label>
            <flux:select wire:model.live="criterioExistencias" size="sm">
                <option value="todos">Todas</option>
                <option value=">">Mayor a 0</option>
                <option value="<">Menor a 0</option>
                <option value="=">Igual a 0</option>
            </flux:select>
        </flux:field>
    </div>

    {{-- Checkbox de productos inactivos --}}
    <flux:field class="mt-4" variant="inline">
        <flux:label class="flex items-center gap-2 cursor-pointer">
            <flux:checkbox wire:model.live="considerarProductosInactivos" />
            <span class="text-sm text-gray-700 dark:text-gray-300">
                Considerar productos inactivos
            </span>
        </flux:label>
    </flux:field>
</div>
