<div class="w-full px-6 py-4">
    <div class="flex items-center justify-between mb-6">
        <h1 class="text-2xl font-semibold">
            Ventas
        </h1>
    </div>

    {{-- Filtros --}}
    <div class="bg-white rounded-lg shadow-sm border p-6 mb-6">
        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
            <div>
                <label for="fecha_inicio" class="block text-sm font-medium mb-1">Fecha inicio:</label>
                <input type="date" id="fecha_inicio" wire:model.live="fechainicio"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
            </div>
            <div>
                <label for="fecha_final" class="block text-sm font-medium mb-1">Fecha final:</label>
                <input type="date" id="fecha_final" wire:model.live="fechafinal"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
            </div>
            <div>
                <label for="sucursal" class="block text-sm font-medium mb-1">Sucursal:</label>
                <select id="sucursal" wire:model.live="sucursal"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todos</option>
                    @foreach ($sucursales ?? [] as $suc)
                        <option value="{{ $suc->idbranchoffice }}">{{ $suc->razon_social }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="usuario" class="block text-sm font-medium mb-1">Usuario:</label>
                <select id="usuario" wire:model.live="usuario"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todos</option>
                    @foreach ($usuarios ?? [] as $usu)
                        <option value="{{ $usu->usuario }}">{{ $usu->usuario }}</option>
                    @endforeach
                </select>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-4 mb-4">
            <div>
                <label for="cliente" class="block text-sm font-medium mb-1">Cliente:</label>
                <div class="relative">
                    <input type="text" id="cliente" wire:model.live="cliente"
                        class="w-full border border-gray-300 rounded px-3 py-2 pr-10 text-sm" placeholder="Todos">
                    <button type="button"
                        class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                    <button type="button"
                        class="absolute right-8 top-1/2 -translate-y-1/2 text-red-400 hover:text-red-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                    </button>
                </div>
            </div>
            <div>
                <label for="turnos" class="block text-sm font-medium mb-1">Turnos:</label>
                <div class="relative">
                    <input type="text" id="turnos" wire:model.live="turno"
                        class="w-full border border-gray-300 rounded px-3 py-2 pr-10 text-sm" placeholder="">
                    <button type="button"
                        class="absolute right-2 top-1/2 -translate-y-1/2 text-gray-400 hover:text-gray-600">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
                        </svg>
                    </button>
                </div>
            </div>
            <div>
                <label for="tipo_pago" class="block text-sm font-medium mb-1">Tipo de pago:</label>
                <select id="tipo_pago" wire:model.live="tipopago"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todos</option>
                    @foreach ($tiposPago ?? [] as $tipo)
                        <option value="{{ $tipo->formadepago }}">{{ $tipo->formadepago }}</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="origen" class="block text-sm font-medium mb-1">Origen de venta:</label>
                <select id="origen" wire:model.live="origenVenta"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="todos">Todos</option>
                    <option value="factura">Factura</option>
                    <option value="venta">Nota de venta</option>
                </select>
            </div>
            <div>
                <label for="estatus" class="block text-sm font-medium mb-1">Estatus:</label>
                <select id="estatus" wire:model.live="estatus"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="">Todos</option>
                    <option value="cerrada">Cerrada</option>
                    <option value="cancelada">Cancelada</option>
                </select>
            </div>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
            <div>
                <label for="filas" class="block text-sm font-medium mb-1">Número de filas:</label>
                <select id="filas" wire:model.live="filas"
                    class="w-full border border-gray-300 rounded px-3 py-2 text-sm">
                    <option value="10">10</option>
                    <option value="20">20</option>
                    <option value="50">50</option>
                    <option value="100">100</option>
                </select>
            </div>
            <div class="md:col-span-3 flex items-end gap-3">
                <button type="button"
                    class="bg-green-600 hover:bg-green-700 text-white px-6 py-2 rounded text-sm font-medium">
                    <i class="fas fa-file-excel mr-2"></i>
                    Exportar
                </button>
            </div>
        </div>
    </div>

    {{-- Grid con Gráfica y Totales por Tipo de Pago --}}
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mb-6">
        {{-- Gráfica de ventas por fecha --}}
        <div class="bg-white rounded-lg shadow-sm border p-6" wire:key="grafica-{{ md5(json_encode($datosGrafica)) }}">
            <h2 class="text-lg font-semibold mb-4">Ventas por fechas (gráfica de barras)</h2>
            <div class="w-full" style="height: 400px;">
                <canvas id="ventasChart"
                    data-labels="{{ json_encode($datosGrafica->pluck('periodo')->toArray()) }}"
                    data-valores="{{ json_encode($datosGrafica->pluck('total')->toArray()) }}">
                </canvas>
            </div>
        </div>

        {{-- Total de ventas por tipo de pago --}}
        <div class="bg-white rounded-lg shadow-sm border p-6">
            <h2 class="text-lg font-semibold mb-4">Total de ventas (por tipo de pago)</h2>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead>
                        <tr class="border-b">
                            <th class="text-left py-2 px-4 font-semibold">Tipo pago</th>
                            <th class="text-right py-2 px-4 font-semibold">Total</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($ventasPorTipoPago ?? [] as $tipoPago)
                            <tr class="border-b hover:bg-gray-50">
                                <td class="py-2 px-4">{{ $tipoPago->tipopago }}</td>
                                <td class="py-2 px-4 text-right">$ {{ number_format($tipoPago->total, 2) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="2" class="py-4 px-4 text-center text-gray-500">No hay datos</td>
                            </tr>
                        @endforelse
                        <tr class="bg-gray-100 font-bold">
                            <td class="py-2 px-4">SUBTOTAL</td>
                            <td class="py-2 px-4 text-right">{{ number_format($subtotalVentas ?? 0, 2) }}</td>
                        </tr>
                        <tr class="border-b">
                            <td class="py-2 px-4 italic text-gray-600">COMISION X EFECTIVO</td>
                            <td class="py-2 px-4 text-right italic text-gray-600">${{ number_format($totalComisiones ?? 0, 2) }}</td>
                        </tr>
                        <tr class="bg-gray-200 font-bold text-lg">
                            <td class="py-3 px-4">TOTAL</td>
                            <td class="py-3 px-4 text-right">${{ number_format($totalGeneral ?? 0, 2) }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    {{-- Contador de Ventas Totales --}}
    <div class="mb-4">
        <p class="text-sm font-medium">Ventas totales: {{ $totalVentas ?? 0 }}</p>
    </div>

    {{-- Tabla de Facturas --}}
    <div class="bg-white rounded-lg shadow-sm border overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-sm">
                <thead class="bg-gray-100 border-b">
                    <tr>
                        <th class="text-left px-4 py-3 font-semibold">Turno</th>
                        <th class="text-left px-4 py-3 font-semibold">Fecha-hora</th>
                        <th class="text-left px-4 py-3 font-semibold">Tipo pago</th>
                        <th class="text-right px-4 py-3 font-semibold">Total</th>
                        <th class="text-left px-4 py-3 font-semibold">Folio</th>
                        <th class="text-left px-4 py-3 font-semibold">Folio fiscal</th>
                        <th class="text-left px-4 py-3 font-semibold">Cliente</th>
                        <th class="text-left px-4 py-3 font-semibold">Usuario</th>
                        <th class="text-left px-4 py-3 font-semibold">Sucursal</th>
                        <th class="text-center px-4 py-3 font-semibold">Inf.</th>
                    </tr>
                </thead>
                <tbody class="divide-y">
                    @forelse ($ventas ?? [] as $venta)
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-3">{{ $venta->idturno }}</td>
                            <td class="px-4 py-3">{{ \Carbon\Carbon::parse($venta->fechahora)->format('Y-m-d h:i a') }}</td>
                            <td class="px-4 py-3">{{ $venta->tipopago }}</td>
                            <td class="px-4 py-3 text-right font-semibold">${{ number_format($venta->total, 2) }}</td>
                            <td class="px-4 py-3">{{ $venta->folio }}</td>
                            <td class="px-4 py-3 text-xs">{{ $venta->foliofiscal }}</td>
                            <td class="px-4 py-3">{{ $venta->cliente }}</td>
                            <td class="px-4 py-3">{{ $venta->usuario }}</td>
                            <td class="px-4 py-3">{{ $venta->sucursal }}</td>
                            <td class="px-4 py-3 text-center">
                                <button class="text-blue-600 hover:text-blue-800">
                                    <i class="fas fa-info-circle text-lg"></i>
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="10" class="px-4 py-8 text-center text-gray-500">
                                No se encontraron facturas para los filtros seleccionados.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('scripts')
    <script>
        let miGrafica = null;

        function crearActualizarGrafica() {
            
            const canvas = document.getElementById('ventasChart');
            if (!canvas) {
                return false;
            }
            if (typeof crearGraficaBarras === 'undefined') {
                return false;
            }

            let labels, valores;
            try {
                labels = JSON.parse(canvas.getAttribute('data-labels') || '[]');
                valores = JSON.parse(canvas.getAttribute('data-valores') || '[]');
                
                valores = valores.map(v => parseFloat(v) || 0);
            } catch (e) {
                console.error('Error al parsear datos:', e);
                return false;
            }
            
            if (!labels || labels.length === 0) {
                console.warn('No hay datos para la gráfica');
                return false;
            }
            if (miGrafica) {
                try {
                    miGrafica.destroy();
                } catch (e) {
                    console.warn('Error al destruir gráfica:', e);
                }
                miGrafica = null;
            }

            const opciones = {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: { display: false },
                    title: {
                        display: true,
                        text: 'Ventas por Periodo',
                        font: { size: 18 }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            callback: function(value) {
                                return '$' + value.toLocaleString('es-MX', {
                                    minimumFractionDigits: 2,
                                    maximumFractionDigits: 2
                                });
                            }
                        }
                    }
                }
            };

            try {
                miGrafica = crearGraficaBarras('ventasChart', labels, valores, opciones);
                return true;
            } catch (error) {
                console.error('Error al crear gráfica:', error);
                return false;
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            setTimeout(() => {
                crearActualizarGrafica();
            }, 500);
        });

        document.addEventListener('livewire:navigated', function() {
            setTimeout(() => {
                crearActualizarGrafica();
            }, 300);
        });

        Livewire.hook('morph.updated', ({ el, component }) => {
            setTimeout(() => {
                crearActualizarGrafica();
            }, 300);
        });

        document.addEventListener('livewire:update', function() {
            setTimeout(() => {
                crearActualizarGrafica();
            }, 300);
        });
    </script>
@endpush
