<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reporte de Cortes de Caja</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
        }
        .header h1 {
            font-size: 18px;
            margin: 5px 0;
        }
        .header p {
            font-size: 11px;
            margin: 3px 0;
        }
        .info-box {
            background-color: #f3f4f6;
            padding: 10px;
            margin-bottom: 15px;
            border-radius: 5px;
        }
        .info-box p {
            margin: 3px 0;
        }
        .summary-box {
            background-color: #e0f2fe;
            padding: 10px;
            margin: 15px 0;
            border-radius: 5px;
        }
        .summary-box table {
            width: 100%;
        }
        .summary-box td {
            padding: 3px 5px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        th {
            background-color: #1e293b;
            color: white;
            padding: 8px 5px;
            text-align: left;
            font-size: 9px;
            font-weight: bold;
        }
        td {
            padding: 6px 5px;
            border-bottom: 1px solid #e5e7eb;
            font-size: 9px;
        }
        tr:nth-child(even) {
            background-color: #f9fafb;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .footer-totals {
            background-color: #f3f4f6;
            font-weight: bold;
        }
        .footer {
            margin-top: 20px;
            text-align: center;
            font-size: 8px;
            color: #6b7280;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>REPORTE DE CORTES DE CAJA</h1>
        @if(!empty($filtros['fechaInicio']) && !empty($filtros['fechaFin']))
            <p>Período: {{ \Carbon\Carbon::parse($filtros['fechaInicio'])->format('d/m/Y') }} al {{ \Carbon\Carbon::parse($filtros['fechaFin'])->format('d/m/Y') }}</p>
        @endif
        <p>Generado: {{ now()->format('d/m/Y H:i:s') }}</p>
    </div>

    @if(!empty($filtros))
        <div class="info-box">
            <p><strong>Filtros aplicados:</strong></p>
            @if(!empty($filtros['sucursal']))
                <p>Sucursal: {{ $filtros['sucursal'] }}</p>
            @endif
            @if(!empty($filtros['usuario']))
                <p>Usuario: {{ $filtros['usuario'] }}</p>
            @endif
            @if(!empty($filtros['opcionTurnos']))
                <p>Estado: {{ $filtros['opcionTurnos'] == 1 ? 'Cerrados' : ($filtros['opcionTurnos'] == 0 ? 'No Cerrados' : 'Ambos turnos') }}</p>
            @endif
        </div>
    @endif

    <div class="summary-box">
        <strong>Sumatorias:</strong>
        <table>
            <tr>
                <td><strong>Concepto</strong></td>
                <td class="text-right"><strong>Importe</strong></td>
            </tr>
            <tr>
                <td>Ingresos</td>
                <td class="text-right">${{ number_format($totales['total_ingresos'] ?? 0, 2) }}</td>
            </tr>
            <tr>
                <td>Egresos</td>
                <td class="text-right">${{ number_format($totales['total_egresos'] ?? 0, 2) }}</td>
            </tr>
            <tr>
                <td>Ingresos - Egresos</td>
                <td class="text-right">${{ number_format(($totales['total_ingresos'] ?? 0) - ($totales['total_egresos'] ?? 0), 2) }}</td>
            </tr>
            <tr>
                <td>Cortes de caja empleados</td>
                <td class="text-right">${{ number_format($totales['total_cortes'] ?? 0, 2) }}</td>
            </tr>
            <tr>
                <td><strong>Diferencia</strong></td>
                <td class="text-right"><strong>${{ number_format($totales['diferencia'] ?? 0, 2) }}</strong></td>
            </tr>
        </table>
    </div>

    <table>
        <thead>
            <tr>
                <th>Turno</th>
                <th>F. Apertura</th>
                <th class="text-center">Cerrado</th>
                <th>F. Cierre</th>
                <th class="text-center">Hrs.</th>
                <th class="text-right">Ingresos</th>
                <th class="text-right">Egresos</th>
                <th class="text-right">Ing-Egr</th>
                <th class="text-right">Corte Emp.</th>
                <th class="text-right">Diferencia</th>
                <th>Usuario</th>
            </tr>
        </thead>
        <tbody>
            @foreach($cortes as $corte)
                <tr>
                    <td>{{ $corte->idturno }}</td>
                    <td>{{ $corte->fechahora_apertura ? \Carbon\Carbon::parse($corte->fechahora_apertura)->format('d/m/Y H:i') : 'N/A' }}</td>
                    <td class="text-center">{{ $corte->turno_cerrado ? 'Sí' : 'No' }}</td>
                    <td>{{ $corte->fechahora_cierre ? \Carbon\Carbon::parse($corte->fechahora_cierre)->format('d/m/Y H:i') : 'N/A' }}</td>
                    <td class="text-center">
                        @if($corte->fechahora_apertura && $corte->fechahora_cierre)
                            {{ round(\Carbon\Carbon::parse($corte->fechahora_apertura)->diffInHours(\Carbon\Carbon::parse($corte->fechahora_cierre)), 2) }}
                        @else
                            N/A
                        @endif
                    </td>
                    <td class="text-right">${{ number_format($corte->ingresos ?? 0, 2) }}</td>
                    <td class="text-right">${{ number_format($corte->egresos ?? 0, 2) }}</td>
                    <td class="text-right">${{ number_format(($corte->ingresos ?? 0) - ($corte->egresos ?? 0), 2) }}</td>
                    <td class="text-right">${{ number_format($corte->total_corte ?? 0, 2) }}</td>
                    <td class="text-right">${{ number_format(($corte->total_corte ?? 0) - (($corte->ingresos ?? 0) - ($corte->egresos ?? 0)), 2) }}</td>
                    <td>{{ $corte->usuario }}</td>
                </tr>
            @endforeach
            <tr class="footer-totals">
                <td colspan="5">TOTALES</td>
                <td class="text-right">${{ number_format($totales['total_ingresos'] ?? 0, 2) }}</td>
                <td class="text-right">${{ number_format($totales['total_egresos'] ?? 0, 2) }}</td>
                <td class="text-right">${{ number_format(($totales['total_ingresos'] ?? 0) - ($totales['total_egresos'] ?? 0), 2) }}</td>
                <td class="text-right">${{ number_format($totales['total_cortes'] ?? 0, 2) }}</td>
                <td class="text-right">${{ number_format($totales['diferencia'] ?? 0, 2) }}</td>
                <td></td>
            </tr>
        </tbody>
    </table>

    <div class="footer">
        <p>Registros totales: {{ count($cortes) }}</p>
    </div>
</body>
</html>
