<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>Mapro - Punto de Venta | Sistema de Gestión Empresarial</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=poppins:300,400,500,600,700&display=swap" rel="stylesheet" />

        <!-- Styles -->
        @vite(['resources/css/app.css', 'resources/js/app.js'])
        
        <style>
            body {
                font-family: 'Poppins', sans-serif;
            }
            
            .gradient-primary {
                background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%);
            }
            
            .gradient-orange {
                background: linear-gradient(135deg, #F97316 0%, #EA580C 100%);
            }
            
            .text-gradient {
                background: linear-gradient(135deg, #3B82F6 0%, #2563EB 100%);
                -webkit-background-clip: text;
                -webkit-text-fill-color: transparent;
                background-clip: text;
            }
            
            .hero-section {
                background: linear-gradient(135deg, rgba(59, 130, 246, 0.05) 0%, rgba(37, 99, 235, 0.05) 100%);
            }
            
            .feature-icon {
                transition: all 0.3s ease;
            }
            
            .feature-card:hover .feature-icon {
                transform: scale(1.1);
            }
            
            .feature-card {
                transition: all 0.3s ease;
                border: 1px solid #e5e7eb;
            }
            
            .feature-card:hover {
                transform: translateY(-8px);
                box-shadow: 0 20px 40px rgba(59, 130, 246, 0.1);
                border-color: #3B82F6;
            }
            
            .pricing-card {
                transition: all 0.3s ease;
                position: relative;
            }
            
            .pricing-card:hover {
                transform: translateY(-10px);
                box-shadow: 0 25px 50px rgba(0, 0, 0, 0.15);
            }
            
            .pricing-card.featured {
                border: 2px solid #F97316;
                transform: scale(1.05);
            }
            
            .badge-discount {
                position: absolute;
                top: -12px;
                right: 20px;
                background: #EF4444;
                color: white;
                padding: 4px 12px;
                border-radius: 20px;
                font-size: 12px;
                font-weight: 600;
            }
            
            @keyframes fadeInUp {
                from {
                    opacity: 0;
                    transform: translateY(30px);
                }
                to {
                    opacity: 1;
                    transform: translateY(0);
                }
            }
            
            .animate-fade-in-up {
                animation: fadeInUp 0.8s ease-out;
            }
            
            .scroll-smooth {
                scroll-behavior: smooth;
            }
        </style>
    </head>
    <body class="antialiased bg-white scroll-smooth">
        <!-- Navigation -->
        <nav class="bg-white shadow-sm fixed w-full top-0 z-50 border-b border-gray-100">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex justify-between h-20">
                    <div class="flex items-center">
                        <div class="flex items-center gap-3">
                            <img src="{{ asset('imagenes/logo_enkelt.avif') }}" alt="Enkelt Logo" class="w-40 h-20 object-contain">
                            <div>
                                <span class="text-2xl font-bold text-gray-900">Mapro</span>
                                <p class="text-xs text-gray-500">Punto de Venta</p>
                            </div>
                        </div>
                    </div>
                    <div class="hidden md:flex items-center gap-8">
                        <a href="#inicio" class="text-gray-700 hover:text-blue-600 transition font-medium">Inicio</a>
                        <a href="#caracteristicas" class="text-gray-700 hover:text-blue-600 transition font-medium">Características</a>
                        <a href="#precios" class="text-gray-700 hover:text-blue-600 transition font-medium">Precios</a>
                        <a href="#contacto" class="text-gray-700 hover:text-blue-600 transition font-medium">Contacto</a>
                    </div>
                    <div class="flex items-center gap-4">
                        @if (Route::has('login'))
                            @auth
                                <a href="{{ url('/dashboard') }}" class="text-gray-700 hover:text-blue-600 transition font-medium">Dashboard</a>
                            @else
                                <a href="{{ route('login') }}" class="text-gray-700 hover:text-blue-600 transition font-medium">Iniciar Sesión</a>
                            @endauth
                        @endif
                    </div>
                </div>
            </div>
        </nav>

        <!-- Hero Section -->
        <section id="inicio" class="hero-section pt-32 pb-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid lg:grid-cols-2 gap-12 items-center">
                    <div class="animate-fade-in-up">
                        <div class="inline-block mb-4">
                            <span class="bg-blue-100 text-blue-700 px-4 py-2 rounded-full text-sm font-semibold">
                                ✨ Sistema de Gestión Empresarial
                            </span>
                        </div>
                        <h1 class="text-5xl md:text-6xl font-bold text-gray-900 mb-6 leading-tight">
                            Información real<br>
                            <span class="text-gradient">y al momento</span>
                        </h1>
                        <p class="text-xl text-gray-600 mb-8 leading-relaxed">
                            Con el sistema <span class="font-semibold text-gray-900">Mapro - Punto de Venta</span> es posible realizar más de 30 reportes diferentes para tomar las decisiones correctas.
                        </p>
                        <ul class="space-y-3 mb-8">
                            <li class="flex items-center gap-3 text-gray-700">
                                <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                Analiza tus ventas día a día o del período que elijas
                            </li>
                            <li class="flex items-center gap-3 text-gray-700">
                                <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                Visualiza la rotación de productos
                            </li>
                            <li class="flex items-center gap-3 text-gray-700">
                                <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                Conoce el ticket promedio y las horas pico del negocio
                            </li>
                            <li class="flex items-center gap-3 text-gray-700">
                                <svg class="w-6 h-6 text-blue-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"/>
                                </svg>
                                ¡Y mucho más!
                            </li>
                        </ul>
                        <div class="flex gap-4 flex-wrap">
                            <a href="#contacto" class="gradient-primary text-white px-8 py-4 rounded-xl font-semibold hover:shadow-xl transition transform hover:scale-105">
                                Contáctanos
                            </a>
                        </div>
                    </div>
                    <div class="relative">
                        <div class="bg-gradient-to-br from-blue-500 to-blue-600 rounded-2xl p-8 shadow-2xl transform hover:scale-105 transition">
                            <div class="bg-white rounded-lg p-6 shadow-lg">
                                <div class="flex items-center justify-between mb-4">
                                    <span class="font-bold text-gray-800">Dashboard de Ventas</span>
                                    <div class="flex gap-2">
                                        <div class="w-3 h-3 rounded-full bg-red-500"></div>
                                        <div class="w-3 h-3 rounded-full bg-yellow-500"></div>
                                        <div class="w-3 h-3 rounded-full bg-green-500"></div>
                                    </div>
                                </div>
                                
                                <!-- Gráfica de Ventas -->
                                <div class="space-y-4">
                                    <div class="flex items-end justify-between gap-2 px-4" style="height: 200px;">
                                        <!-- Barra 1 - Lunes -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-blue-500 to-blue-400 rounded-t-lg" style="height: 90px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Lun</span>
                                        </div>
                                        <!-- Barra 2 - Martes -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-blue-500 to-blue-400 rounded-t-lg" style="height: 124px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Mar</span>
                                        </div>
                                        <!-- Barra 3 - Miércoles -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-blue-500 to-blue-400 rounded-t-lg" style="height: 110px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Mié</span>
                                        </div>
                                        <!-- Barra 4 - Jueves (destacada) -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-orange-500 to-orange-400 rounded-t-lg" style="height: 156px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Jue</span>
                                        </div>
                                        <!-- Barra 5 - Viernes -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-blue-500 to-blue-400 rounded-t-lg" style="height: 136px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Vie</span>
                                        </div>
                                        <!-- Barra 6 - Sábado -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-blue-500 to-blue-400 rounded-t-lg" style="height: 170px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Sáb</span>
                                        </div>
                                        <!-- Barra 7 - Domingo -->
                                        <div class="flex flex-col items-center justify-end flex-1 h-full gap-2">
                                            <div class="w-full bg-gradient-to-t from-blue-500 to-blue-400 rounded-t-lg" style="height: 104px;"></div>
                                            <span class="text-xs text-gray-600 font-medium">Dom</span>
                                        </div>
                                    </div>
                                    
                                    <!-- Métricas rápidas -->
                                    <div class="grid grid-cols-3 gap-3 pt-4 border-t border-gray-100">
                                        <div class="text-center">
                                            <div class="text-lg font-bold text-gray-900">$45k</div>
                                            <div class="text-xs text-gray-500">Ventas</div>
                                        </div>
                                        <div class="text-center">
                                            <div class="text-lg font-bold text-gray-900">1.2k</div>
                                            <div class="text-xs text-gray-500">Productos</div>
                                        </div>
                                        <div class="text-center">
                                            <div class="text-lg font-bold text-gray-900">$367</div>
                                            <div class="text-xs text-gray-500">Promedio</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section id="caracteristicas" class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-bold text-gray-900 mb-4">
                        Funciones y <span class="text-gradient">Características</span>
                    </h2>
                    <p class="text-xl text-gray-600">Todo lo que necesitas para gestionar tu negocio de forma profesional</p>
                </div>
                
                <div class="grid md:grid-cols-2 lg:grid-cols-4 gap-6 mb-12">
                    <!-- Feature 1 - Ventas -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-16 h-16 bg-blue-100 rounded-2xl flex items-center justify-center mb-4 mx-auto">
                            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 3h2l.4 2M7 13h10l4-8H5.4M7 13L5.4 5M7 13l-2.293 2.293c-.63.63-.184 1.707.707 1.707H17m0 0a2 2 0 100 4 2 2 0 000-4zm-8 2a2 2 0 11-4 0 2 2 0 014 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-3 text-center">Ventas</h3>
                        <p class="text-gray-600 text-sm text-center">Tu proceso de ventas y las operaciones del punto de venta: transacciones y notas de venta</p>
                    </div>

                    <!-- Feature 2 - Inventarios -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-16 h-16 bg-blue-100 rounded-2xl flex items-center justify-center mb-4 mx-auto">
                            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-3 text-center">Inventarios</h3>
                        <p class="text-gray-600 text-sm text-center">Controla tus inventarios y visualiza existencias de productos o insumos</p>
                    </div>

                    <!-- Feature 3 - Caja -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-16 h-16 bg-blue-100 rounded-2xl flex items-center justify-center mb-4 mx-auto">
                            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 9V7a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2m2 4h10a2 2 0 002-2v-6a2 2 0 00-2-2H9a2 2 0 00-2 2v6a2 2 0 002 2zm7-5a2 2 0 11-4 0 2 2 0 014 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-3 text-center">Caja</h3>
                        <p class="text-gray-600 text-sm text-center">Realiza los cortes de caja con el sistema</p>
                    </div>

                    <!-- Feature 4 - Facturación -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-16 h-16 bg-blue-100 rounded-2xl flex items-center justify-center mb-4 mx-auto">
                            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-3 text-center">Facturación Fácil</h3>
                        <p class="text-gray-600 text-sm text-center">Facturación electrónica al instante. Puedes facturar notas de venta o realizar una facturación global</p>
                    </div>
                </div>

                <!-- Additional Features -->
                <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-6">
                    <!-- Compras -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-14 h-14 gradient-orange rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-2">Compras</h3>
                        <p class="text-gray-600 text-sm">Registra tus documentos de compra e integra automáticamente tus pedidos al inventario</p>
                    </div>

                    <!-- Cuentas por Cobrar -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-14 h-14 gradient-orange rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-2">Cuentas por Cobrar</h3>
                        <p class="text-gray-600 text-sm">Lleva un control total de crédito y cobranza a tus clientes, identifica saldos pendientes y aplica pagos</p>
                    </div>

                    <!-- Cuentas por Pagar -->
                    <div class="feature-card bg-white p-6 rounded-2xl">
                        <div class="feature-icon w-14 h-14 gradient-orange rounded-xl flex items-center justify-center mb-4">
                            <svg class="w-7 h-7 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                            </svg>
                        </div>
                        <h3 class="text-lg font-bold text-gray-900 mb-2">Cuentas por Pagar</h3>
                        <p class="text-gray-600 text-sm">Lleva un control de pagos a proveedores y de tus cuentas por pagar</p>
                    </div>
                </div>

                <!-- Industries Section -->
                <div class="mt-20 text-center">
                    <h3 class="text-3xl font-bold text-gray-900 mb-4">¿A quién está dirigido?</h3>
                    <p class="text-xl text-gray-600 mb-12">El mejor aliado de tu negocio</p>
                    
                    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-8">
                        <div class="text-center">
                            <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <svg class="w-10 h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                </svg>
                            </div>
                            <p class="font-semibold text-gray-900">Papelerías</p>
                        </div>
                        <div class="text-center">
                            <div class="w-20 h-20 bg-orange-100 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <svg class="w-10 h-10 text-orange-600" fill="currentColor" viewBox="0 0 20 20">
                                    <path d="M10 3.5a1.5 1.5 0 013 0V4a1 1 0 001 1h3a1 1 0 011 1v3a1 1 0 01-1 1h-.5a1.5 1.5 0 000 3h.5a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-.5a1.5 1.5 0 00-3 0v.5a1 1 0 01-1 1H6a1 1 0 01-1-1v-3a1 1 0 00-1-1h-.5a1.5 1.5 0 010-3H4a1 1 0 001-1V6a1 1 0 011-1h3a1 1 0 001-1v-.5z"/>
                                </svg>
                            </div>
                            <p class="font-semibold text-gray-900">Fruterías</p>
                        </div>
                        <div class="text-center">
                            <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <svg class="w-10 h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 15.546c-.523 0-1.046.151-1.5.454a2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.704 2.704 0 00-3 0 2.704 2.704 0 01-3 0 2.701 2.701 0 00-1.5-.454M9 6v2m3-2v2m3-2v2M9 3h.01M12 3h.01M15 3h.01M21 21v-7a2 2 0 00-2-2H5a2 2 0 00-2 2v7h18zm-3-9v-2a2 2 0 00-2-2H8a2 2 0 00-2 2v2h12z"/>
                                </svg>
                            </div>
                            <p class="font-semibold text-gray-900">Dulcerías</p>
                        </div>
                        <div class="text-center">
                            <div class="w-20 h-20 bg-orange-100 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <svg class="w-10 h-10 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"/>
                                </svg>
                            </div>
                            <p class="font-semibold text-gray-900">Carnicerías</p>
                        </div>
                        <div class="text-center">
                            <div class="w-20 h-20 bg-blue-100 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <svg class="w-10 h-10 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 11V7a4 4 0 00-8 0v4M5 9h14l1 12H4L5 9z"/>
                                </svg>
                            </div>
                            <p class="font-semibold text-gray-900">Boutiques</p>
                        </div>
                        <div class="text-center">
                            <div class="w-20 h-20 bg-orange-100 rounded-full flex items-center justify-center mb-3 mx-auto">
                                <svg class="w-10 h-10 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"/>
                                </svg>
                            </div>
                            <p class="font-semibold text-gray-900">Y más...</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Benefits Section -->
        <section class="py-20 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">¿Por qué elegir Mapro - Punto de venta?</h2>
                </div>
                
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div class="space-y-8">
                        <div class="flex gap-4">
                            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18.364 5.636l-3.536 3.536m0 5.656l3.536 3.536M9.172 9.172L5.636 5.636m3.536 9.192l-3.536 3.536M21 12a9 9 0 11-18 0 9 9 0 0118 0zm-5 0a4 4 0 11-8 0 4 4 0 018 0z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 mb-2">Soporte técnico cuando lo necesites</h3>
                                <p class="text-gray-600">Nos comprometemos a brindarte un servicio en todo momento</p>
                            </div>
                        </div>
                        
                        <div class="flex gap-4">
                            <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 mb-2">Obtén reportes rápidamente</h3>
                                <p class="text-gray-600">Conoce día a día, las ventas y utilidades de tu negocio en automático</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="space-y-8">
                        <div class="flex gap-4">
                            <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 mb-2">Trabajamos día con día</h3>
                                <p class="text-gray-600">En realizar mejoras para tu negocio, por lo que año con año tendrás actualizaciones a la vanguardia</p>
                            </div>
                        </div>
                        
                        <div class="flex gap-4">
                            <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center flex-shrink-0">
                                <svg class="w-6 h-6 text-orange-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.663 17h4.673M12 3v1m6.364 1.636l-.707.707M21 12h-1M4 12H3m3.343-5.657l-.707-.707m2.828 9.9a5 5 0 117.072 0l-.548.547A3.374 3.374 0 0014 18.469V19a2 2 0 11-4 0v-.531c0-.895-.356-1.754-.988-2.386l-.548-.547z"/>
                                </svg>
                            </div>
                            <div>
                                <h3 class="text-xl font-bold text-gray-900 mb-2">No requiere conocimientos en computación</h3>
                                <p class="text-gray-600">Las operaciones de la empresa se optimizan mediante la facilidad de manejo y lo amigable del sistema</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section id="contacto" class="gradient-primary py-20">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h2 class="text-4xl md:text-5xl font-bold text-white mb-6">
                    Contáctanos para realizar tu compra
                </h2>
                <p class="text-xl text-white/90 mb-8">
                    Queremos elevar tu negocio al siguiente nivel, de la manera más fácil y eficaz
                </p>
                <p class="text-2xl font-bold text-white mb-8">¡No esperes más!</p>
                
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="https://wa.me/5219992897565" target="_blank" class="bg-white text-blue-600 px-8 py-4 rounded-xl font-semibold hover:bg-gray-100 transition shadow-lg inline-flex items-center justify-center gap-2">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                            <path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.01-.57-.01-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413z"/>
                        </svg>
                        WhatsApp
                    </a>
                    <a href="tel:+529992897565" class="bg-orange-500 text-white px-8 py-4 rounded-xl font-semibold hover:bg-orange-600 transition shadow-lg inline-flex items-center justify-center gap-2">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                        </svg>
                        Llamar Ahora
                    </a>
                </div>
                
                <p class="text-white/80 mt-8">
                    C. 67A 192, entre 67 y Av. Zamná, Yucalpetén, 97238 Mérida, Yuc.
                </p>
            </div>
        </section>

        <!-- Footer -->
        <footer class="bg-gray-900 text-white py-12">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid md:grid-cols-4 gap-8 mb-8">
                    <div>
                        <div class="flex items-center gap-3 mb-4">
                            <img src="{{ asset('imagenes/logo_enkelt.avif') }}" alt="Enkelt Logo" class="w-20 h-20 object-contain">
                            <div>
                                <h3 class="text-xl font-bold">Mapro</h3>
                                <p class="text-xs text-gray-400">Punto de Venta</p>
                            </div>
                        </div>
                        <p class="text-gray-400 text-sm">Sistema de gestión empresarial completo para tu negocio</p>
                        
                        <div class="flex gap-4 mt-4">
                            <a href="#" class="w-10 h-10 bg-gray-800 rounded-lg flex items-center justify-center hover:bg-blue-600 transition">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M24 12.073c0-6.627-5.373-12-12-12s-12 5.373-12 12c0 5.99 4.388 10.954 10.125 11.854v-8.385H7.078v-3.47h3.047V9.43c0-3.007 1.792-4.669 4.533-4.669 1.312 0 2.686.235 2.686.235v2.953H15.83c-1.491 0-1.956.925-1.956 1.874v2.25h3.328l-.532 3.47h-2.796v8.385C19.612 23.027 24 18.062 24 12.073z"/>
                                </svg>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-800 rounded-lg flex items-center justify-center hover:bg-blue-600 transition">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.953 4.57a10 10 0 01-2.825.775 4.958 4.958 0 002.163-2.723c-.951.555-2.005.959-3.127 1.184a4.92 4.92 0 00-8.384 4.482C7.69 8.095 4.067 6.13 1.64 3.162a4.822 4.822 0 00-.666 2.475c0 1.71.87 3.213 2.188 4.096a4.904 4.904 0 01-2.228-.616v.06a4.923 4.923 0 003.946 4.827 4.996 4.996 0 01-2.212.085 4.936 4.936 0 004.604 3.417 9.867 9.867 0 01-6.102 2.105c-.39 0-.779-.023-1.17-.067a13.995 13.995 0 007.557 2.209c9.053 0 13.998-7.496 13.998-13.985 0-.21 0-.42-.015-.63A9.935 9.935 0 0024 4.59z"/>
                                </svg>
                            </a>
                            <a href="#" class="w-10 h-10 bg-gray-800 rounded-lg flex items-center justify-center hover:bg-red-600 transition">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24">
                                    <path d="M23.498 6.186a3.016 3.016 0 0 0-2.122-2.136C19.505 3.545 12 3.545 12 3.545s-7.505 0-9.377.505A3.017 3.017 0 0 0 .502 6.186C0 8.07 0 12 0 12s0 3.93.502 5.814a3.016 3.016 0 0 0 2.122 2.136c1.871.505 9.376.505 9.376.505s7.505 0 9.377-.505a3.015 3.015 0 0 0 2.122-2.136C24 15.93 24 12 24 12s0-3.93-.502-5.814zM9.545 15.568V8.432L15.818 12l-6.273 3.568z"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                    <div>
                        <h4 class="font-semibold mb-4 text-lg">Producto</h4>
                        <ul class="space-y-3 text-gray-400 text-sm">
                            <li><a href="#caracteristicas" class="hover:text-white transition">Características</a></li>
                            <li><a href="#precios" class="hover:text-white transition">Precios</a></li>
                            <li><a href="#" class="hover:text-white transition">Demo</a></li>
                            <li><a href="#" class="hover:text-white transition">Módulos</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold mb-4 text-lg">Empresa</h4>
                        <ul class="space-y-3 text-gray-400 text-sm">
                            <li><a href="#" class="hover:text-white transition">Acerca de</a></li>
                            <li><a href="#contacto" class="hover:text-white transition">Contacto</a></li>
                            <li><a href="#" class="hover:text-white transition">Soporte</a></li>
                            <li><a href="#" class="hover:text-white transition">Blog</a></li>
                        </ul>
                    </div>
                    <div>
                        <h4 class="font-semibold mb-4 text-lg">Contacto</h4>
                        <ul class="space-y-3 text-gray-400 text-sm">
                            <li class="flex items-center gap-2">
                                <svg class="w-5 h-5 text-blue-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"/>
                                </svg>
                                <span>999 289 7565</span>
                            </li>
                            <li class="flex items-start gap-2">
                                <svg class="w-5 h-5 text-blue-500 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.657 16.657L13.414 20.9a1.998 1.998 0 01-2.827 0l-4.244-4.243a8 8 0 1111.314 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 11a3 3 0 11-6 0 3 3 0 016 0z"/>
                                </svg>
                                <span>C. 67A 192, Yucalpetén<br>97238 Mérida, Yuc.</span>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="border-t border-gray-800 pt-8">
                    <div class="flex flex-col md:flex-row justify-between items-center gap-4">
                        <p class="text-gray-400 text-sm">&copy; {{ date('Y') }} Mapro - Punto de Venta. Todos los derechos reservados.</p>
                        <div class="flex gap-6 text-sm text-gray-400">
                            <a href="#" class="hover:text-white transition">Privacidad</a>
                            <a href="#" class="hover:text-white transition">Términos</a>
                            <a href="#" class="hover:text-white transition">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
    </body>
</html>
