<?php

declare(strict_types=1);

use App\Http\Middleware\EnsureTenantStorage;
use App\Http\Middleware\InitializeTenancyByAuth;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Storage;

/*
|--------------------------------------------------------------------------
| Tenant Routes
|--------------------------------------------------------------------------
|
| Here you can register the tenant routes for your application.
| These routes are loaded by the TenantRouteServiceProvider.
|
| Feel free to customize them however you want. Good luck!
|
*/

Route::middleware([
    'web',
    'auth',
    InitializeTenancyByAuth::class,
    EnsureTenantStorage::class,
])->group(function () {
    Route::view('dashboard', 'dashboard')
        ->middleware(['auth', 'verified'])
        ->name('dashboard');

    Route::group(['prefix' => 'ventas'], function () {
        Route::group(['prefix' => 'cotizaciones'], function () {
            Route::get('/', \App\Livewire\Ventas\Cotizaciones\Index::class)->name('d-ventas-cotizaciones');
        });
    });

    Route::group(['prefix' => 'puntodeventa'], function () {
        Route::group(['prefix' => 'puntoventas'], function () {
            Route::get('/', \App\Livewire\PuntoDeVenta\PuntoVentas\Index::class)->name('d-puntodeventa-puntoventas');
        });
    });

    Route::post('logout', App\Livewire\Actions\Logout::class)
        ->name('logout');

    Route::group(['prefix' => 'catalogos'], function () {
        Route::group(['prefix' => 'familias'], function () {
            Route::get('/', \App\Livewire\Catalogos\Familia\Index::class)->name('d-catalogos-familias');
            Route::get('/create', \App\Livewire\Catalogos\Familia\Create::class)->name('d-catalogos-familias-create');
            Route::get('/{family}/edit', \App\Livewire\Catalogos\Familia\Edit::class)->name('d-catalogos-familias-edit');
        });
        Route::group(['prefix' => 'marcas'], function () {
            Route::get('/', \App\Livewire\Catalogos\Marca\Index::class)->name('d-catalogos-marcas');
            Route::get('/create', \App\Livewire\Catalogos\Marca\Create::class)->name('d-catalogos-marca-create');
            Route::get('/{marca}/edit', \App\Livewire\Catalogos\Marca\Edit::class)->name('d-catalogos-marca-edit');
        });

        Route::group(['prefix' => 'proveedores'], function () {
            Route::get('/', \App\Livewire\Catalogos\Proveedores\Index::class)->name('d-catalogos-proveedores');
            Route::get('/create', \App\Livewire\Catalogos\Proveedores\Create::class)->name('d-catalogos-proveedores-create');
            Route::get('/{proveedor}/edit', \App\Livewire\Catalogos\Proveedores\Edit::class)->name('d-catalogos-proveedores-edit');
        });

        Route::group(['prefix' => 'usuarios'], function () {
            Route::get('/', \App\Livewire\Catalogos\Usuario\Index::class)->name('d-catalogos-usuarios');
            Route::get('/create', \App\Livewire\Catalogos\Usuario\Create::class)->name('d-catalogos-usuarios-create');
            Route::get('/{user}/edit', \App\Livewire\Catalogos\Usuario\Edit::class)->name('d-catalogos-usuarios-edit');
        });

        Route::group(['prefix' => 'productos'], function () {
            Route::get('/', App\Livewire\Catalogos\Productos\Index::class)->name('d-catalogos-productos');
            Route::get('/create', App\Livewire\Catalogos\Productos\Create::class)->name('d-catalogos-productos-create');
            Route::get('/{producto}/edit', App\Livewire\Catalogos\Productos\Edit::class)->name('d-catalogos-productos-edit');
        });

        Route::group(['prefix' => 'conceptos'], function () {
            Route::get('/', \App\Livewire\Catalogos\Conceptos\Index::class)->name('d-catalogos-conceptos');
            Route::get('/create', \App\Livewire\Catalogos\Conceptos\Create::class)->name('d-catalogos-conceptos-create');
            Route::get('/{concepto}/edit', \App\Livewire\Catalogos\Conceptos\Edit::class)->name('d-catalogos-conceptos-edit');
        });

        Route::get('/image-preview/{path}', function ($path) {
            $path = str_replace('..', '', $path);
            $fullPath = $path;
            if ($fullPath[0] == '/') {
                $fullPath = substr($fullPath, 1);
            }

            if (! Storage::disk('local')->exists($fullPath)) {
                abort(404);
            }

            $file = Storage::disk('local')->get($fullPath);
            $type = Storage::mimeType($fullPath);

            return Response::make($file, 200)->header('Content-Type', $type);
        })->where('path', '.*')->name('private.image');
    });

    Route::group(['prefix' => 'inventarios'], function () {
        Route::group(['prefix' => 'establecerstock'], function () {
            Route::get('/', \App\Livewire\Inventarios\Establecerstock\Index::class)->name('d-inventarios-establecerstock');
        });
        Route::group(['prefix' => 'cambiarprecios'], function () {
            Route::get('/', \App\Livewire\Inventarios\CambiarPrecios\Index::class)->name('d-inventarios-cambiarprecios');
        });
        Route::get('/movimientos', \App\Livewire\Inventarios\Movimiento::class)->name('d-inventarios-movimientos');
        Route::get('/traspasos', \App\Livewire\Inventarios\Traspaso::class)->name('d-inventarios-traspasos');
    });

    Route::group(['prefix' => 'reportes'], function () {
        Route::group(['prefix' => 'cortes-caja'], function () {
            Route::get('/', \App\Livewire\Reportes\CortesCaja\Index::class)->name('d-reportes-cortes-caja');
            Route::get('/concentrado', \App\Livewire\Reportes\CortesCaja\Concentrado::class)->name('d-reportes-cortes-caja-concentrado');
            Route::get('/{idturno}/{idsucursal}', \App\Livewire\Reportes\CortesCaja\Detalle::class)->name('d-reportes-cortes-caja-detalle');
        });
        Route::get('ventas-familia-producto', \App\Livewire\Reportes\VentasFamiliaProducto::class)->name('d-reportes-ventas-familia-producto');
        Route::get('existencias-por-sucursales', \App\Livewire\Reportes\VentasPorSucursales::class)->name('d-reportes-existencias-por-sucursales');
        Route::group(['prefix' => 'lo_mas_menos_vendido'], function () {
            Route::get('/', \App\Livewire\Reportes\LoMasMenosVendido\Index::class)->name('d-reportes-lo-mas-menos-vendido');
        });
        Route::group(['prefix' => 'ventas'], function () {
            Route::get('/', \App\Livewire\Reportes\Ventaspor\Index::class)->name('d-reportes-ventas');
        });
        Route::redirect('/reportes/ventas_por_fecha', '/reportes/ventas');
        Route::redirect('/reportes/ventas_por_facturacion', '/reportes/ventas');
        Route::group(['prefix' => 'costo-utilidad'], function () {
            Route::get('/', \App\Livewire\Reportes\CostoUtilidad\Index::class)->name('d-reportes-costo-utilidad');
        });
    });
});

require __DIR__.'/auth.php';
