<div class="flex flex-shrink-0 transition-all">
    <base href="<?php echo e(url('/')); ?>/">
    <div x-show="isSidebarOpen || isSidebarPinned" class="fixed inset-y-0 z-10 w-16 bg-white"></div>
    <!-- Left mini bar -->
    <nav aria-label="Options"
        class="z-20 flex-col items-center flex-shrink-0 hidden w-16 py-4 bg-white border-r-2 border-indigo-100 shadow-md sm:flex">
        <!-- Logo -->
        <div class="flex flex-col items-center p-3">
            <a href="/dashboard">
                <img src="<?php echo e(central_asset('imagenes/M.png')); ?>" alt="Logo">
            </a>
        </div>
        <div class="flex flex-col items-center flex-1 p-2 space-y-4">
            <!-- Home button -->
            <button class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white">
                <a href="/dashboard">
                    <svg aria-hidden="true" class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none"
                        viewBox="0 0 24 24" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            stroke-width="2"d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                    </svg>
                </a>
            </button>
            <!-- Ventas button -->
            <button @mouseover="hoverTab('ventas')" @mouseleave="leaveTab()" @click="toggleTab('ventas')"
                class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white"
                :class="(currentSidebarTab == 'messagesTab' && isSidebarPinned) ? 'text-white bg-indigo-600' :
                'text-gray-500 bg-white'">
                <svg aria-hidden="true" class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="#000000"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path d="M3 3v18h18v-2H5V3H3zm4 10h2v5H7v-5zm4-4h2v9h-2v-9zm4-4h2v13h-2V5z" />
                </svg>
            </button>
            <!-- Punto de venta button -->
            <button @mouseover="hoverTab('punto_venta')" @mouseleave="leaveTab()" @click="toggleTab('punto_venta')"
                class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white"
                :class="(currentSidebarTab == 'messagesTab' && isSidebarPinned) ? 'text-white bg-indigo-600' :
                'text-gray-500 bg-white'">
                <svg aria-hidden="true" class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="#000000"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path d="M3 3v18h18v-2H5V3H3zm4 10h2v5H7v-5zm4-4h2v9h-2v-9zm4-4h2v13h-2V5z" />
                </svg>
            </button>
            <!-- Reportes button -->
            <button @mouseover="hoverTab('reportes')" @mouseleave="leaveTab()" @click="toggleTab('reportes')"
                class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white"
                :class="(currentSidebarTab == 'messagesTab' && isSidebarPinned) ? 'text-white bg-indigo-600' :
                'text-gray-500 bg-white'">
                <svg aria-hidden="true" class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="#000000"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path d="M3 3v18h18v-2H5V3H3zm4 10h2v5H7v-5zm4-4h2v9h-2v-9zm4-4h2v13h-2V5z" />
                </svg>
            </button>
            <!-- Catalogos button -->
            <button @mouseover="hoverTab('catalogos')" @mouseleave="leaveTab()" @click="toggleTab('catalogos')"
                class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white focus:outline-none"
                :class="(currentSidebarTab == 'notificationsTab' && isSidebarPinned) ? 'text-white bg-indigo-600' :
                'text-gray-500 bg-white'">
                <svg aria-hidden="true" class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="#000000"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path d="M3 3v18h18v-2H5V3H3zm4 10h2v5H7v-5zm4-4h2v9h-2v-9zm4-4h2v13h-2V5z" />
                </svg>
            </button>

            <!-- Inventarios button -->
            <button @mouseover="hoverTab('inventarios')" @mouseleave="leaveTab()" @click="toggleTab('inventarios')"
                class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white focus:outline-none"
                :class="(currentSidebarTab == 'notificationsTab' && isSidebarPinned) ? 'text-white bg-indigo-600' :
                'text-gray-500 bg-white'">
                <svg aria-hidden="true" class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="#000000"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path d="M3 3v18h18v-2H5V3H3zm4 10h2v5H7v-5zm4-4h2v9h-2v-9zm4-4h2v13h-2V5z" />
                </svg>
            </button>
        </div>
        <!-- Botón en la parte inferior -->
        <div class="mt-auto px-4 py-6">
            <div x-data="{ open: false }" class="relative">
                <button @click="open = !open"
                    class="p-2 transition-colors rounded-lg shadow-md hover:bg-indigo-800 hover:text-white">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor"
                        viewBox="0 0 24 24">
                        <path
                            d="M19.14,12.94a7.05,7.05,0,0,0,0-1.88l2.11-1.65a.5.5,0,0,0,.12-.65l-2-3.46a.5.5,0,0,0-.61-.22l-2.49,1a7.09,7.09,0,0,0-1.62-.94l-.38-2.65a.5.5,0,0,0-.5-.42H10a.5.5,0,0,0-.5.42l-.38,2.65a7.09,7.09,0,0,0-1.62.94l-2.49-1a.5.5,0,0,0-.61.22l-2,3.46a.5.5,0,0,0,.12.65L4.86,11.06a7.05,7.05,0,0,0,0,1.88L2.75,14.59a.5.5,0,0,0-.12.65l2,3.46a.5.5,0,0,0,.61.22l2.49-1a7.09,7.09,0,0,0,1.62.94l.38,2.65a.5.5,0,0,0,.5.42h4a.5.5,0,0,0,.5-.42l.38-2.65a7.09,7.09,0,0,0,1.62-.94l2.49,1a.5.5,0,0,0,.61-.22l2-3.46a.5.5,0,0,0-.12-.65ZM12,15.5A3.5,3.5,0,1,1,15.5,12,3.5,3.5,0,0,1,12,15.5Z" />
                    </svg>
                </button>

                <!-- Menú desplegable -->
                <div x-show="open" @click.away="open = false"
                    class="absolute bottom-full right-0 z-20 w-48 mb-2 bg-white rounded-lg shadow-lg transform translate-x-full">
                    <a href="/ajustes" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Configuración</a>
                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                        <?php echo csrf_field(); ?>
                        <button type="submit"
                            class="w-full text-left px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">
                            Log Out
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </nav>

    <div x-transition:enter="transform transition-transform duration-300" x-transition:enter-start="-translate-x-full"
        x-transition:enter-end="translate-x-0" x-transition:leave="transform transition-transform duration-300"
        x-transition:leave-start="translate-x-0" x-transition:leave-end="-translate-x-full"
        x-show="isSidebarOpen || isSidebarPinned"
        class="fixed inset-y-0 left-0 z-10 flex-shrink-0 w-64 bg-white border-r-2 border-indigo-100 shadow-lg sm:left-16 rounded-tr-3xl rounded-br-3xl sm:w-72 lg:w-64">
        <nav x-show="currentSidebarTab == 'linksTab'" aria-label="Main" class="flex flex-col h-full">
            <!-- Logo -->
            <div class="flex items-center justify-center flex-shrink-0 py-10">
                <a href="/">
                    <img class="w-24 h-auto" src="" alt="" />
                </a>
            </div>

            <!-- Links -->
            <div class="flex-1 px-4 space-y-2 overflow-hidden hover:overflow-auto">
                <a href="/dashboard" class="flex items-center w-full space-x-2 text-white bg-indigo-600 rounded-lg">
                    <span aria-hidden="true" class="p-2 bg-indigo-700 rounded-lg">
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M3 12l2-2m0 0l7-7 7 7M5 10v10a1 1 0 001 1h3m10-11l2 2m-2-2v10a1 1 0 01-1 1h-3m-6 0a1 1 0 001-1v-4a1 1 0 011-1h2a1 1 0 011 1v4a1 1 0 001 1m-6 0h6" />
                        </svg>
                    </span>
                    <span>Home</span>
                </a>
                <a href="#"
                    class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                    <span aria-hidden="true"
                        class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                        <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                            stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                        </svg>
                    </span>
                    <span>Pages</span>
                </a>
            </div>
        </nav>

        <section x-show="currentSidebarTab == 'ventas'" class="px-4 py-6">
            <h2 class="text-xl">Ventas</h2>
            <a href="ventas/cotizaciones"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Cotizaciones</span>
            </a>
        </section>

        <section x-show="currentSidebarTab == 'punto_venta'" class="px-4 py-6">
            <h2 class="text-xl">Punto de Venta</h2>
            <a href="puntodeventa/puntoventas"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Punto de Venta</span>
            </a>
        </section>

        <section x-show="currentSidebarTab == 'reportes'" class="px-4 py-6">
            <h2 class="text-xl">Reportes</h2>
            <a href="reportes/ventas"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Ventas por fecha/facturación</span>
            </a>
            <a href="reportes/lo_mas_menos_vendido"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Lo más/menos vendidos</span>
            </a>
            <a href="reportes/ventas-familia-producto"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Ventas por familia/producto</span>
            </a>
            <a href="#"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Información existencias</span>
            </a>
            <a href="reportes/existencias-por-sucursales"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Existencias por sucursales</span>
            </a>
            <a href="reportes/cortes-caja"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Cortes de caja</span>
            </a>
            <a href="reportes/costo-utilidad"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Costo-Utilidad</span>
            </a>
            <a href="#"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Doc. ingreso y egresos</span>
            </a>
        </section>

        <section x-show="currentSidebarTab == 'catalogos'" class="px-4 py-6">
            <h2 class="text-xl">Catalogos</h2>
            <a href="catalogos/usuarios"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </span>
                <span>Usuarios</span>
            </a>
            <a href="catalogos/familias"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </span>
                <span>Familias</span>
            </a>
            <a href="catalogos/marcas"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </span>
                <span>Marcas</span>
            </a>
            <a href="catalogos/productos"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </span>
                <span>Productos</span>
            </a>
            <a href="catalogos/proveedores"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </span>
                <span>
                    Proveedores
                </span>
            </a>
            <a href="catalogos/conceptos"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                    </svg>
                </span>
                <span>
                    Conceptos de inventarios
                </span>
            </a>
        </section>

        <section x-show="currentSidebarTab == 'inventarios'" class="px-4 py-6">
            <h2 class="text-xl">Inventarios</h2>
            <a href="inventarios/establecerstock"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Establecer stock</span>
            </a>
            <a href="inventarios/cambiarprecios"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Entradas</span>
            </a>
            <a href="inventarios/movimientos"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <circle cx="12" cy="12" r="9" stroke="currentColor" stroke-width="2"
                            fill="none" />
                    </svg>
                </span>
                <span>Movimientos</span>
            </a>
            <a href="inventarios/traspasos"
                class="flex items-center space-x-2 text-indigo-600 transition-colors rounded-lg group hover:bg-indigo-600 hover:text-white">
                <span aria-hidden="true"
                    class="p-2 transition-colors rounded-lg group-hover:bg-indigo-700 group-hover:text-white">
                    <svg class="w-6 h-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                            d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4" />
                    </svg>
                </span>
                <span>Traspasos</span>
            </a>
        </section>
    </div>
</div>
<?php /**PATH /Users/gabrielsp/Documents/Development/Enkelt/resources/views/components/layouts/app/sidebar.blade.php ENDPATH**/ ?>