<div>
    <?php $__env->startPush('styles'); ?>
    <style>
        .stat-card {
            transition: all 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15);
        }
        .chart-container {
            transition: all 0.3s ease;
        }
        .chart-container:hover {
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }
    </style>
    <?php $__env->stopPush(); ?>

    <div class="flex h-full w-full flex-1 flex-col gap-6 p-4 md:p-6">
        <!-- Header Section -->
        <div class="flex items-center justify-between">
            <div>
                <?php if (isset($component)) { $__componentOriginale0fd5b6a0986beffac17a0a103dfd7b9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale0fd5b6a0986beffac17a0a103dfd7b9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::heading','data' => ['class' => 'text-sm text-gray-600 dark:text-gray-400 mt-1']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::heading'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'text-sm text-gray-600 dark:text-gray-400 mt-1']); ?>Estadísticas de hoy <?php echo e(date('d-m-Y')); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale0fd5b6a0986beffac17a0a103dfd7b9)): ?>
<?php $attributes = $__attributesOriginale0fd5b6a0986beffac17a0a103dfd7b9; ?>
<?php unset($__attributesOriginale0fd5b6a0986beffac17a0a103dfd7b9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale0fd5b6a0986beffac17a0a103dfd7b9)): ?>
<?php $component = $__componentOriginale0fd5b6a0986beffac17a0a103dfd7b9; ?>
<?php unset($__componentOriginale0fd5b6a0986beffac17a0a103dfd7b9); ?>
<?php endif; ?>
            </div>
            <div class="flex items-center gap-2">
                <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                </svg>
                <span class="text-sm font-medium text-gray-700 dark:text-gray-300"><?php echo e(date('d-m-Y')); ?></span>
            </div>
        </div>

        <?php
            $sTotalPromedio = $sVentaxEmp = $sTotalRegistro = 0;
        ?>

        <!-- Statistics Table -->
        <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
            <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-white">Ventas por Sucursal</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-sm">
                    <thead class="bg-gray-50 dark:bg-gray-900">
                        <tr>
                            
                            <th class="px-6 py-4 text-left font-semibold text-gray-700 dark:text-gray-300">Sucursal</th>
                            <th class="px-6 py-4 text-right font-semibold text-gray-700 dark:text-gray-300">Importe Venta</th>
                            <th class="px-6 py-4 text-right font-semibold text-gray-700 dark:text-gray-300">Cantidad de Ventas</th>
                            <th class="px-6 py-4 text-right font-semibold text-gray-700 dark:text-gray-300">Promedio de Ventas</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-700">
                        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__empty_1 = true; $__currentLoopData = $totalventasxempresa; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ventaxemp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                            <td class="px-6 py-4 text-gray-900 dark:text-gray-100"><?php echo e($ventaxemp->sucursal); ?></td>
                            <td class="px-6 py-4 text-right font-semibold text-green-600 dark:text-green-400">
                                $<?php echo e(number_format($ventaxemp->total, 2)); ?>

                                <?php $sVentaxEmp += $ventaxemp->total; ?>
                            </td>
                            <td class="px-6 py-4 text-right text-gray-900 dark:text-gray-100">
                                <?php echo e($ventaxemp->totalregistros); ?>

                                <?php $sTotalRegistro += $ventaxemp->totalregistros; ?>
                            </td>
                            <td class="px-6 py-4 text-right text-gray-900 dark:text-gray-100">
                                $<?php echo e(number_format(($ventaxemp->total/$ventaxemp->totalregistros), 2)); ?>

                                <?php $sTotalPromedio += $ventaxemp->total/$ventaxemp->totalregistros; ?>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center text-gray-500 dark:text-gray-400">
                                No hay ventas registradas para el día de hoy
                            </td>
                        </tr>
                        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                    </tbody>
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(count($totalventasxempresa) > 0): ?>
                    <tfoot class="bg-gray-100 dark:bg-gray-900">
                        <tr class="font-bold">
                            <td class="px-6 py-4 text-gray-900 dark:text-white">Totales</td>
                            <td class="px-6 py-4 text-right text-green-600 dark:text-green-400 text-lg">
                                $<?php echo e(number_format($sVentaxEmp, 2)); ?>

                            </td>
                            <td class="px-6 py-4 text-right text-gray-900 dark:text-white text-lg">
                                <?php echo e($sTotalRegistro); ?>

                            </td>
                            <td class="px-6 py-4 text-right text-gray-900 dark:text-white text-lg">
                                $<?php echo e(number_format($sTotalPromedio, 2)); ?>

                            </td>
                        </tr>
                    </tfoot>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
                </table>
            </div>
        </div>

        <!-- Charts Section -->
        <div class="grid gap-6 md:grid-cols-2">
            <!-- Chart 1: Ventas del día por hora -->
            <div class="chart-container bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Ventas del día por hora</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Gráfica de barras</p>
                    </div>
                    <div class="flex gap-2">
                        <button class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors" onclick="toggleChart('chart1')">
                            <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div id="chart1" class="px-6 py-4">
                    <canvas id="barchart11" style="height:280px"></canvas>
                </div>
            </div>

            <!-- Chart 2: Ventas del mes por día -->
            <div class="chart-container bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Ventas del mes por día</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Gráfica de barras</p>
                    </div>
                    <div class="flex gap-2">
                        <button class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors" onclick="toggleChart('chart2')">
                            <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div id="chart2" class="px-6 py-4">
                    <canvas id="barchart12" style="height:280px"></canvas>
                </div>
            </div>

            <!-- Chart 3: Ventas del año por mes -->
            <div class="chart-container bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Ventas del año por mes</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Gráfica de barras</p>
                    </div>
                    <div class="flex gap-2">
                        <button class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors" onclick="toggleChart('chart3')">
                            <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div id="chart3" class="px-6 py-4">
                    <canvas id="barchart21" style="height:280px"></canvas>
                </div>
            </div>

            <!-- Chart 4: Ventas globales por año -->
            <div class="chart-container bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden border border-gray-200 dark:border-gray-700">
                <div class="px-6 py-4 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-800 dark:text-white">Ventas globales por año</h3>
                        <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">Gráfica de barras</p>
                    </div>
                    <div class="flex gap-2">
                        <button class="p-2 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors" onclick="toggleChart('chart4')">
                            <svg class="w-5 h-5 text-gray-600 dark:text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <div id="chart4" class="px-6 py-4">
                    <canvas id="barchart22" style="height:280px"></canvas>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // Toggle chart visibility
        function toggleChart(chartId) {
            const chart = document.getElementById(chartId);
            if (chart) {
                chart.classList.toggle('hidden');
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            initCharts();
        });

        function initCharts() {
            // Chart.js configuration
            const isDarkMode = document.documentElement.classList.contains('dark');
            const textColor = isDarkMode ? '#e5e7eb' : '#1f2937';
            const gridColor = isDarkMode ? 'rgba(255, 255, 255, 0.1)' : 'rgba(0, 0, 0, 0.1)';

            const barChartOptions = {
                responsive: true,
                maintainAspectRatio: true,
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            fontColor: textColor
                        },
                        gridLines: {
                            color: gridColor,
                            drawBorder: false
                        }
                    }],
                    xAxes: [{
                        ticks: {
                            fontColor: textColor
                        },
                        gridLines: {
                            color: gridColor,
                            drawBorder: false
                        }
                    }]
                },
                legend: {
                    display: false
                },
                tooltips: {
                    callbacks: {
                        label: function(tooltipItem) {
                            return '$' + tooltipItem.yLabel.toLocaleString('es-MX', { minimumFractionDigits: 2 });
                        }
                    }
                }
            };

            // Chart 1: Ventas por hora
            const ctx1 = document.getElementById('barchart11');
            if (ctx1) {
                new Chart(ctx1.getContext('2d'), {
                    type: 'bar',
                    data: {
                        labels: [<?php $__currentLoopData = $ventasxhora; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>"<?php echo e($reg->horaventa); ?>:00",<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                        datasets: [{
                            label: "Ventas por Hora",
                            backgroundColor: "rgba(59, 130, 246, 0.8)",
                            borderColor: "rgba(59, 130, 246, 1)",
                            borderWidth: 1,
                            data: [<?php $__currentLoopData = $ventasxhora; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($reg->totalxhora); ?>,<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                        }]
                    },
                    options: barChartOptions
                });
            }

            // Chart 2: Ventas por día del mes
            const ctx2 = document.getElementById('barchart12');
            if (ctx2) {
                new Chart(ctx2.getContext('2d'), {
                    type: 'bar',
                    data: {
                        labels: [<?php $__currentLoopData = $totalventasxmes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>"<?php echo e($reg->diaventa); ?>",<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                        datasets: [{
                            label: "Ventas por Día",
                            backgroundColor: "rgba(16, 185, 129, 0.8)",
                            borderColor: "rgba(16, 185, 129, 1)",
                            borderWidth: 1,
                            data: [<?php $__currentLoopData = $totalventasxmes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($reg->totalxdia); ?>,<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                        }]
                    },
                    options: barChartOptions
                });
            }

            // Chart 3: Ventas por mes del año
            const ctx3 = document.getElementById('barchart21');
            if (ctx3) {
                new Chart(ctx3.getContext('2d'), {
                    type: 'bar',
                    data: {
                        labels: [
                            <?php $__currentLoopData = $totalventasxanio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio",
                                          "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
                                echo '"' . $meses[$reg->mesventa - 1] . '",';
                            ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        ],
                        datasets: [{
                            label: "Ventas por Mes",
                            backgroundColor: "rgba(168, 85, 247, 0.8)",
                            borderColor: "rgba(168, 85, 247, 1)",
                            borderWidth: 1,
                            data: [<?php $__currentLoopData = $totalventasxanio; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($reg->totalxmes); ?>,<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                        }]
                    },
                    options: barChartOptions
                });
            }

            // Chart 4: Ventas globales por año
            const ctx4 = document.getElementById('barchart22');
            if (ctx4) {
                new Chart(ctx4.getContext('2d'), {
                    type: 'bar',
                    data: {
                        labels: [<?php $__currentLoopData = $totalventasglobal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>"<?php echo e($reg->anioventa); ?>",<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>],
                        datasets: [{
                            label: "Ventas por Año",
                            backgroundColor: "rgba(249, 115, 22, 0.8)",
                            borderColor: "rgba(249, 115, 22, 1)",
                            borderWidth: 1,
                            data: [<?php $__currentLoopData = $totalventasglobal; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php echo e($reg->totalxanio); ?>,<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>]
                        }]
                    },
                    options: barChartOptions
                });
            }
        }
    </script>
    <?php $__env->stopPush(); ?>
</div><?php /**PATH /Users/gabrielsp/Documents/Development/Enkelt/resources/views/livewire/dashboard.blade.php ENDPATH**/ ?>